/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.tracing.util;

import io.opentracing.propagation.TextMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.XmlHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="tracing-info")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TracingInfoCarrier
implements TextMap {
    private static final Logger LOG = LoggerFactory.getLogger(TracingInfoCarrier.class);
    private Map<String, String> tracingInfoMap = new HashMap<String, String>();

    public TracingInfoCarrier(Map<String, String> tracingInfo) {
        this.tracingInfoMap = tracingInfo;
    }

    public TracingInfoCarrier() {
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        throw new UnsupportedOperationException();
    }

    public void put(String key, String value) {
        this.tracingInfoMap.put(key, value);
    }

    public Map<String, String> getTracingInfoMap() {
        return this.tracingInfoMap;
    }

    public void setTracingInfoMap(Map<String, String> tracingInfoMap) {
        this.tracingInfoMap = tracingInfoMap;
    }

    public static String marshalTracingInfo(Map<String, String> tracingInfo) {
        try {
            TracingInfoCarrier tracingInfoCarrier = new TracingInfoCarrier(tracingInfo);
            return TracingInfoMarshaller.marshalRequest(tracingInfoCarrier);
        }
        catch (Exception e) {
            LOG.warn("Exception while marshalling tracing info {}", tracingInfo, (Object)e);
            return null;
        }
    }

    public static Map<String, String> unmarshalTracinginfo(String tracingInfo) {
        try {
            TracingInfoCarrier tracingInfoCarrier = TracingInfoMarshaller.unmarshalRequest(tracingInfo);
            return tracingInfoCarrier.getTracingInfoMap();
        }
        catch (Exception e) {
            LOG.warn("Exception while unmarshalling tracing info {}", (Object)tracingInfo, (Object)e);
            return new HashMap<String, String>();
        }
    }

    private static class TracingInfoMarshaller {
        private static final ThreadLocal<XmlHandler<TracingInfoCarrier>> xmlHandlerThreadLocal = new ThreadLocal();

        private TracingInfoMarshaller() {
        }

        public static String marshalRequest(TracingInfoCarrier tracingInfo) {
            return TracingInfoMarshaller.createXmlHandler().marshal((Object)tracingInfo);
        }

        public static TracingInfoCarrier unmarshalRequest(String tracingInfo) {
            return (TracingInfoCarrier)TracingInfoMarshaller.createXmlHandler().unmarshal(tracingInfo);
        }

        private static XmlHandler<TracingInfoCarrier> createXmlHandler() {
            XmlHandler xmlHandler = xmlHandlerThreadLocal.get();
            if (xmlHandler == null) {
                xmlHandler = new XmlHandler(TracingInfoCarrier.class);
                xmlHandlerThreadLocal.set((XmlHandler<TracingInfoCarrier>)xmlHandler);
            }
            return xmlHandler;
        }
    }
}

