/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.daemon.DaemonTools;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.syslogd.SyslogReceiver;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@EventListener(name="syslogd", logPrefix="syslogd")
public class Syslogd
extends AbstractServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(Syslogd.class);
    public static final String LOG4J_CATEGORY = "syslogd";
    @Autowired
    private SyslogReceiver m_udpEventReceiver;

    public Syslogd() {
        super(LOG4J_CATEGORY);
    }

    public SyslogReceiver getSyslogReceiver() {
        return this.m_udpEventReceiver;
    }

    public void setSyslogReceiver(SyslogReceiver receiver) {
        this.m_udpEventReceiver = receiver;
    }

    protected void onInit() {
    }

    protected void onStart() {
        LOG.debug("Starting SyslogHandler");
        Thread rThread = new Thread((Runnable)this.m_udpEventReceiver, this.m_udpEventReceiver.getName());
        try {
            rThread.start();
        }
        catch (RuntimeException e) {
            rThread.interrupt();
            throw e;
        }
    }

    protected void onStop() {
        if (this.m_udpEventReceiver != null) {
            LOG.debug("stop: Stopping the Syslogd UDP receiver");
            try {
                this.m_udpEventReceiver.stop();
            }
            catch (InterruptedException e) {
                LOG.info("stop: Exception when stopping the Syslog UDP receiver: " + e.getMessage());
            }
            catch (Throwable e) {
                LOG.error("stop: Failed to stop the Syslog UDP receiver", e);
                throw new UndeclaredThrowableException(e);
            }
            LOG.debug("stop: Stopped the Syslogd UDP receiver");
        }
    }

    private void handleConfigurationChanged() {
        this.stop();
        try {
            this.m_udpEventReceiver.reload();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.start();
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void handleReloadEvent(Event e) {
        DaemonTools.handleReloadEvent((Event)e, (String)LOG4J_CATEGORY, event -> this.handleConfigurationChanged());
    }
}

