/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.opennms.netmgt.syslogd.ByteBufferParser;
import org.opennms.netmgt.syslogd.ParserStage;
import org.opennms.netmgt.syslogd.ParserState;
import org.opennms.netmgt.syslogd.SyslogMessage;

public class SingleSequenceParser
implements ByteBufferParser<SyslogMessage> {
    private final List<ParserStage> m_stages;

    public SingleSequenceParser(List<ParserStage> stages) {
        this.m_stages = Collections.unmodifiableList(stages);
    }

    @Override
    public CompletableFuture<SyslogMessage> parse(ByteBuffer incoming) {
        ParserState state = new ParserState(incoming);
        CompletionStage<ParserState> future = CompletableFuture.completedFuture(state);
        for (ParserStage stage : this.m_stages) {
            future = future.thenApply(stage::apply);
        }
        return future.thenApply(s -> {
            if (s == null) {
                return null;
            }
            return s.message;
        });
    }
}

