/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.proxy.common;

import java.util.Collections;
import java.util.List;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.proxy.common.AbstractSNMPRequestBuilder;
import org.opennms.netmgt.snmp.proxy.common.LocationAwareSnmpClientRpcImpl;
import org.opennms.netmgt.snmp.proxy.common.SnmpMultiResponseDTO;
import org.opennms.netmgt.snmp.proxy.common.SnmpResponseDTO;
import org.opennms.netmgt.snmp.proxy.common.SnmpWalkRequestDTO;

public class SNMPWalkBuilder
extends AbstractSNMPRequestBuilder<List<SnmpResult>> {
    public SNMPWalkBuilder(LocationAwareSnmpClientRpcImpl client, SnmpAgentConfig agent, List<SnmpObjId> oids) {
        super(client, agent, Collections.emptyList(), SNMPWalkBuilder.buildWalkRequests(oids));
    }

    private static List<SnmpWalkRequestDTO> buildWalkRequests(List<SnmpObjId> oids) {
        SnmpWalkRequestDTO walkRequest = new SnmpWalkRequestDTO();
        walkRequest.setOids(oids);
        return Collections.singletonList(walkRequest);
    }

    @Override
    protected List<SnmpResult> processResponse(SnmpMultiResponseDTO response) {
        return response.getResponses().stream().findFirst().map(SnmpResponseDTO::getResults).orElse(Collections.emptyList());
    }
}

