/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.headers;

import com.google.common.base.Throwables;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.common.utils.BufferUtils;
import org.opennms.netmgt.telemetry.common.utils.DnsUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;

public class Inet6Header {
    public final int tos;
    public final int totalLength;
    public final int protocol;
    public final Inet6Address srcAddress;
    public final Inet6Address dstAddress;
    public final Integer srcPort;
    public final Integer dstPort;
    public final Integer tcpFlags;

    public Inet6Header(ByteBuffer buffer) throws InvalidPacketException {
        long version_tc_fl = BufferUtils.uint32((ByteBuffer)buffer);
        if (version_tc_fl >> 28 != 6L) {
            throw new InvalidPacketException(buffer, "Expected IPv6 Header", new Object[0]);
        }
        this.tos = (int)(version_tc_fl >> 20 & 0xFFL);
        this.totalLength = BufferUtils.uint16((ByteBuffer)buffer) + 40;
        this.protocol = BufferUtils.uint8((ByteBuffer)buffer);
        BufferUtils.skip((ByteBuffer)buffer, (int)1);
        try {
            this.srcAddress = (Inet6Address)Inet6Address.getByAddress(BufferUtils.bytes((ByteBuffer)buffer, (int)16));
            this.dstAddress = (Inet6Address)Inet6Address.getByAddress(BufferUtils.bytes((ByteBuffer)buffer, (int)16));
        }
        catch (UnknownHostException e) {
            throw Throwables.propagate((Throwable)e);
        }
        switch (this.protocol) {
            case 6: {
                this.srcPort = BufferUtils.uint16((ByteBuffer)buffer);
                this.dstPort = BufferUtils.uint16((ByteBuffer)buffer);
                BufferUtils.skip((ByteBuffer)buffer, (int)8);
                this.tcpFlags = BufferUtils.uint16((ByteBuffer)buffer) & 0x1FF;
                break;
            }
            case 17: 
            case 132: {
                this.srcPort = BufferUtils.uint16((ByteBuffer)buffer);
                this.dstPort = BufferUtils.uint16((ByteBuffer)buffer);
                this.tcpFlags = null;
                break;
            }
            case 1: 
            case 58: {
                this.srcPort = 0;
                this.dstPort = BufferUtils.uint16((ByteBuffer)buffer);
                this.tcpFlags = null;
                break;
            }
            default: {
                this.srcPort = null;
                this.dstPort = null;
                this.tcpFlags = null;
            }
        }
    }

    public Inet6Header(int tos, int totalLength, int protocol, Inet6Address srcAddress, Inet6Address dstAddress, Integer srcPort, Integer dstPort, Integer tcpFlags) {
        this.tos = tos;
        this.totalLength = totalLength;
        this.protocol = protocol;
        this.srcAddress = srcAddress;
        this.dstAddress = dstAddress;
        this.srcPort = srcPort;
        this.dstPort = dstPort;
        this.tcpFlags = tcpFlags;
    }

    public void writeBson(BsonWriter bsonWriter) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeInt32("tos", this.tos);
        bsonWriter.writeInt32("length", this.totalLength);
        bsonWriter.writeInt32("protocol", this.protocol);
        bsonWriter.writeStartDocument("src_ip");
        bsonWriter.writeString("address", this.srcAddress.getHostAddress());
        DnsUtils.reverseLookup((InetAddress)this.srcAddress).ifPresent(hostname -> bsonWriter.writeString("hostname", hostname));
        bsonWriter.writeEndDocument();
        bsonWriter.writeStartDocument("dst_ip");
        bsonWriter.writeString("address", this.dstAddress.getHostAddress());
        DnsUtils.reverseLookup((InetAddress)this.dstAddress).ifPresent(hostname -> bsonWriter.writeString("hostname", hostname));
        bsonWriter.writeEndDocument();
        if (this.srcPort != null) {
            bsonWriter.writeInt32("src_port", this.srcPort.intValue());
        }
        if (this.dstPort != null) {
            bsonWriter.writeInt32("dst_port", this.dstPort.intValue());
        }
        if (this.tcpFlags != null) {
            bsonWriter.writeInt32("tcp_flags", this.tcpFlags.intValue());
        }
        bsonWriter.writeEndDocument();
    }
}

