/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.common.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.FlowData;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.Mac;

public class SampledEthernet
implements FlowData {
    public final long length;
    public final Mac src_mac;
    public final Mac dst_mac;
    public final long type;

    public SampledEthernet(ByteBuffer buffer) throws InvalidPacketException {
        this.length = BufferUtils.uint32((ByteBuffer)buffer);
        this.src_mac = new Mac(buffer);
        this.dst_mac = new Mac(buffer);
        this.type = BufferUtils.uint32((ByteBuffer)buffer);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("length", this.length).add("src_mac", (Object)this.src_mac).add("dst_mac", (Object)this.dst_mac).add("type", this.type).toString();
    }

    @Override
    public void writeBson(BsonWriter bsonWriter) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeInt64("length", this.length);
        bsonWriter.writeName("src_mac");
        this.src_mac.writeBson(bsonWriter);
        bsonWriter.writeName("dst_mac");
        this.dst_mac.writeBson(bsonWriter);
        bsonWriter.writeInt64("type", this.type);
        bsonWriter.writeEndDocument();
    }
}

