/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.common.utils.BufferUtils;
import org.opennms.netmgt.telemetry.common.utils.DnsUtils;

public class IpV4 {
    public final Inet4Address ip_v4;

    public IpV4(ByteBuffer buffer) {
        try {
            this.ip_v4 = (Inet4Address)Inet4Address.getByAddress(BufferUtils.bytes((ByteBuffer)buffer, (int)4));
        }
        catch (UnknownHostException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ip_v4", (Object)this.ip_v4).toString();
    }

    public void writeBson(BsonWriter bsonWriter) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeString("address", this.ip_v4.getHostAddress());
        DnsUtils.reverseLookup((InetAddress)this.ip_v4).ifPresent(hostname -> bsonWriter.writeString("hostname", hostname));
        bsonWriter.writeEndDocument();
    }
}

