/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.common.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.FlowData;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.NextHop;

public class ExtendedRouter
implements FlowData {
    public final NextHop nexthop;
    public final long src_mask_len;
    public final long dst_mask_len;

    public ExtendedRouter(ByteBuffer buffer) throws InvalidPacketException {
        this.nexthop = new NextHop(buffer);
        this.src_mask_len = BufferUtils.uint32((ByteBuffer)buffer);
        this.dst_mask_len = BufferUtils.uint32((ByteBuffer)buffer);
    }

    public ExtendedRouter(NextHop nexthop, long src_mask_len, long dst_mask_len) {
        this.nexthop = nexthop;
        this.src_mask_len = src_mask_len;
        this.dst_mask_len = dst_mask_len;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nexthop", (Object)this.nexthop).add("src_mask_len", this.src_mask_len).add("dst_mask_len", this.dst_mask_len).toString();
    }

    @Override
    public void writeBson(BsonWriter bsonWriter) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeName("nexthop");
        this.nexthop.writeBson(bsonWriter);
        bsonWriter.writeInt64("src_mask_len", this.src_mask_len);
        bsonWriter.writeInt64("dst_mask_len", this.dst_mask_len);
        bsonWriter.writeEndDocument();
    }
}

