/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.common.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.Array;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.AsPathType;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.FlowData;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.NextHop;

public class ExtendedGateway
implements FlowData {
    public final NextHop nexthop;
    public final long as;
    public final long src_as;
    public final long src_peer_as;
    public final Array<AsPathType> dst_as_path;
    public final Array<UnsignedInteger> communities;
    public final long localpref;

    public ExtendedGateway(ByteBuffer buffer) throws InvalidPacketException {
        this.nexthop = new NextHop(buffer);
        this.as = BufferUtils.uint32((ByteBuffer)buffer);
        this.src_as = BufferUtils.uint32((ByteBuffer)buffer);
        this.src_peer_as = BufferUtils.uint32((ByteBuffer)buffer);
        this.dst_as_path = new Array<Object>(buffer, Optional.empty(), AsPathType::new);
        this.communities = new Array<Object>(buffer, Optional.empty(), BufferUtils::uint32);
        this.localpref = BufferUtils.uint32((ByteBuffer)buffer);
    }

    public ExtendedGateway(NextHop nexthop, long as, long src_as, long src_peer_as, Array<AsPathType> dst_as_path, Array<UnsignedInteger> communities, long localpref) {
        this.nexthop = nexthop;
        this.as = as;
        this.src_as = src_as;
        this.src_peer_as = src_peer_as;
        this.dst_as_path = dst_as_path;
        this.communities = communities;
        this.localpref = localpref;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nexthop", (Object)this.nexthop).add("as", this.as).add("src_as", this.src_as).add("src_peer_as", this.src_peer_as).add("dst_as_path", this.dst_as_path).add("communities", this.communities).add("localpref", this.localpref).toString();
    }

    @Override
    public void writeBson(BsonWriter bsonWriter) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeName("nexthop");
        this.nexthop.writeBson(bsonWriter);
        bsonWriter.writeInt64("as", this.as);
        bsonWriter.writeInt64("src_as", this.src_as);
        bsonWriter.writeInt64("src_peer_as", this.src_peer_as);
        bsonWriter.writeStartArray("dst_as_path");
        for (AsPathType asPathType : this.dst_as_path) {
            asPathType.writeBson(bsonWriter);
        }
        bsonWriter.writeEndArray();
        bsonWriter.writeStartArray("communities");
        for (UnsignedInteger unsignedInteger : this.communities) {
            bsonWriter.writeInt64(unsignedInteger.longValue());
        }
        bsonWriter.writeEndArray();
        bsonWriter.writeInt64("localpref", this.localpref);
        bsonWriter.writeEndDocument();
    }
}

