/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import com.google.common.base.MoreObjects;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.network.InetAddressXmlAdapter;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpVarBindDTO;
import org.opennms.netmgt.snmp.TrapInformation;
import org.opennms.netmgt.trapd.TrapIdentityDTO;

@XmlRootElement(name="trap-dto")
@XmlAccessorType(value=XmlAccessType.NONE)
public class TrapDTO
implements Message {
    @XmlElement(name="agent-address")
    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    private InetAddress agentAddress;
    @XmlElement(name="community")
    private String community;
    @XmlElement(name="version", required=true)
    private String version;
    @XmlElement(name="timestamp")
    private long timestamp;
    @XmlElement(name="pdu-length")
    private int pduLength;
    @XmlElement(name="creation-time")
    private long creationTime;
    @XmlElement(name="raw-message")
    private byte[] rawMessage;
    @XmlElement(name="trap-identity")
    private TrapIdentityDTO trapIdentity;
    @XmlElementWrapper(name="results")
    @XmlElement(name="result")
    private List<SnmpResult> results = new ArrayList<SnmpResult>();

    public TrapDTO() {
    }

    public TrapDTO(TrapInformation trapInfo) {
        this.setAgentAddress(trapInfo.getAgentAddress());
        this.setCommunity(trapInfo.getCommunity());
        this.setVersion(trapInfo.getVersion());
        this.setTimestamp(trapInfo.getTimeStamp());
        this.setPduLength(trapInfo.getPduLength());
        this.setCreationTime(trapInfo.getCreationTime());
        this.setTrapIdentity(new TrapIdentityDTO(trapInfo.getTrapIdentity()));
        ArrayList<SnmpResult> results = new ArrayList<SnmpResult>();
        for (int i = 0; i < trapInfo.getPduLength(); ++i) {
            SnmpVarBindDTO varBindDTO = trapInfo.getSnmpVarBindDTO(i);
            if (varBindDTO == null) continue;
            SnmpResult snmpResult = new SnmpResult(varBindDTO.getSnmpObjectId(), null, varBindDTO.getSnmpValue());
            results.add(snmpResult);
        }
        this.setResults(results);
    }

    private void setResults(List<SnmpResult> results) {
        this.results = new ArrayList<SnmpResult>(results);
    }

    public void setAgentAddress(InetAddress agentAddress) {
        this.agentAddress = agentAddress;
    }

    public InetAddress getAgentAddress() {
        return this.agentAddress;
    }

    public void setCommunity(String community) {
        this.community = community;
    }

    public String getCommunity() {
        return this.community;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setPduLength(int pduLength) {
        this.pduLength = pduLength;
    }

    public int getPduLength() {
        return this.pduLength;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setTrapIdentity(TrapIdentityDTO trapIdentity) {
        this.trapIdentity = trapIdentity;
    }

    public TrapIdentityDTO getTrapIdentity() {
        return this.trapIdentity;
    }

    public List<SnmpResult> getResults() {
        return this.results;
    }

    public byte[] getRawMessage() {
        return this.rawMessage;
    }

    public void setRawMessage(byte[] rawMessage) {
        this.rawMessage = rawMessage;
    }

    public int hashCode() {
        return Objects.hash(this.community, this.version, this.timestamp, this.pduLength, this.creationTime, this.rawMessage, this.trapIdentity, this.results, this.agentAddress);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TrapDTO other = (TrapDTO)obj;
        boolean equals = Objects.equals(this.community, other.community) && Objects.equals(this.version, other.version) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.pduLength, other.pduLength) && Objects.equals(this.creationTime, other.creationTime) && Objects.equals(this.rawMessage, other.rawMessage) && Objects.equals(this.trapIdentity, other.trapIdentity) && Objects.equals(this.results, other.results) && Objects.equals(this.agentAddress, other.agentAddress);
        return equals;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("agentAddress", (Object)this.agentAddress).add("community", (Object)this.community).add("trapIdentity", (Object)this.trapIdentity).add("creationTime", this.creationTime).add("pduLength", this.pduLength).add("timestamp", this.timestamp).add("version", (Object)this.version).add("rawMessage", (Object)this.rawMessage).toString();
    }
}

