/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.spifly;

import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import org.apache.aries.spifly.BaseActivator;
import org.apache.aries.spifly.ConsumerHeaderProcessor;
import org.apache.aries.spifly.ProviderPrototypeServiceFactory;
import org.apache.aries.spifly.ProviderServiceFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class ProviderBundleTrackerCustomizer
implements BundleTrackerCustomizer {
    private static final String METAINF_SERVICES = "META-INF/services";
    final BaseActivator activator;
    final Bundle spiBundle;

    public ProviderBundleTrackerCustomizer(BaseActivator activator, Bundle spiBundle) {
        this.activator = activator;
        this.spiBundle = spiBundle;
    }

    /*
     * WARNING - void declaration
     */
    public List<ServiceRegistration> addingBundle(Bundle bundle, BundleEvent event) {
        Object bcp;
        this.log(Level.FINE, "Bundle Considered for SPI providers: " + bundle.getSymbolicName());
        if (bundle.equals(this.spiBundle)) {
            return null;
        }
        List<String> providedServices = null;
        HashMap<String, Object> customAttributes = new HashMap<String, Object>();
        if (bundle.getHeaders().get("Require-Capability") != null) {
            try {
                providedServices = this.readServiceLoaderMediatorCapabilityMetadata(bundle, customAttributes);
            }
            catch (InvalidSyntaxException e) {
                this.log(Level.SEVERE, "Unable to read capabilities from bundle " + bundle, e);
            }
        }
        boolean fromSPIProviderHeader = false;
        String spiProviderHeader = this.getHeaderFromBundleOrFragment(bundle, "SPI-Provider");
        if (providedServices == null && spiProviderHeader != null) {
            String header = spiProviderHeader.trim();
            providedServices = "*".equals(header) ? new ArrayList<String>() : Arrays.asList(header.split(","));
            fromSPIProviderHeader = true;
        }
        if (providedServices == null) {
            this.log(Level.FINE, "No 'SPI-Provider' Manifest header. Skipping bundle: " + bundle.getSymbolicName());
            return null;
        }
        this.log(Level.INFO, "Examining bundle for SPI provider: " + bundle.getSymbolicName());
        for (String svc : providedServices) {
            this.activator.registerProviderBundle(svc, bundle, customAttributes);
        }
        ArrayList<Object> serviceFileURLs = new ArrayList<Object>();
        Enumeration entries = bundle.findEntries(METAINF_SERVICES, "*", false);
        if (entries != null) {
            serviceFileURLs.addAll(Collections.list(entries));
        }
        if ((bcp = bundle.getHeaders().get("Bundle-ClassPath")) instanceof String) {
            void var12_15;
            String[] stringArray = ((String)bcp).split(",");
            int n = stringArray.length;
            boolean bl = false;
            while (var12_15 < n) {
                URL url;
                String entry = stringArray[var12_15];
                if (!(entry = entry.trim()).equals(".") && (url = bundle.getResource(entry)) != null) {
                    serviceFileURLs.addAll(this.getMetaInfServiceURLsFromJar(url));
                }
                ++var12_15;
            }
        }
        ArrayList<ServiceRegistration> registrations = new ArrayList<ServiceRegistration>();
        for (URL uRL : serviceFileURLs) {
            this.log(Level.INFO, "Found SPI resource: " + uRL);
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                String className = null;
                while ((className = reader.readLine()) != null) {
                    try {
                        if ((className = className.trim()).length() == 0 || className.startsWith("#")) continue;
                        String serviceFile = uRL.toExternalForm();
                        int idx = serviceFile.lastIndexOf(47);
                        String registrationClassName = className;
                        if (serviceFile.length() > idx) {
                            registrationClassName = serviceFile.substring(idx + 1);
                        }
                        if (providedServices.size() > 0 && !providedServices.contains(registrationClassName)) continue;
                        Class cls = bundle.loadClass(className);
                        this.log(Level.INFO, "Loaded SPI provider: " + cls);
                        Hashtable<Object, Object> properties = fromSPIProviderHeader ? new Hashtable() : this.findServiceRegistrationProperties(bundle.getHeaders(), registrationClassName, className);
                        if (properties != null) {
                            properties.put("serviceloader.mediator", this.spiBundle.getBundleId());
                            properties.put(".org.apache.aries.spifly.provider.implclass", cls.getName());
                            ServiceRegistration reg = null;
                            ProviderServiceFactory instance = properties.containsKey("service.scope") && "prototype".equals(properties.get("service.scope")) ? new ProviderPrototypeServiceFactory(cls) : new ProviderServiceFactory(cls);
                            SecurityManager sm = System.getSecurityManager();
                            if (sm != null) {
                                if (bundle.hasPermission((Object)new ServicePermission(registrationClassName, "register"))) {
                                    reg = bundle.getBundleContext().registerService(registrationClassName, (Object)instance, properties);
                                } else {
                                    this.log(Level.INFO, "Bundle " + bundle + " does not have the permission to register services of type: " + registrationClassName);
                                }
                            } else {
                                reg = bundle.getBundleContext().registerService(registrationClassName, (Object)instance, properties);
                            }
                            if (reg != null) {
                                registrations.add(reg);
                                this.log(Level.INFO, "Registered service: " + reg);
                            }
                        }
                        this.activator.registerProviderBundle(registrationClassName, bundle, customAttributes);
                        this.log(Level.INFO, "Registered provider: " + registrationClassName + " in bundle " + bundle.getSymbolicName());
                    }
                    catch (Exception e) {
                        this.log(Level.WARNING, "Could not load SPI implementation referred from " + uRL, e);
                    }
                }
            }
            catch (IOException e) {
                this.log(Level.WARNING, "Could not read SPI metadata from " + uRL, e);
            }
        }
        return registrations;
    }

    private String getHeaderFromBundleOrFragment(Bundle bundle, String headerName) {
        return this.getHeaderFromBundleOrFragment(bundle, headerName, null);
    }

    private String getHeaderFromBundleOrFragment(Bundle bundle, String headerName, String matchString) {
        BundleWiring wiring;
        String val = (String)bundle.getHeaders().get(headerName);
        if (this.matches(val, matchString)) {
            return val;
        }
        BundleRevision rev = (BundleRevision)bundle.adapt(BundleRevision.class);
        if (rev != null && (wiring = rev.getWiring()) != null) {
            for (BundleWire wire : wiring.getProvidedWires("osgi.wiring.host")) {
                Bundle fragment = wire.getRequirement().getRevision().getBundle();
                val = (String)fragment.getHeaders().get(headerName);
                if (!this.matches(val, matchString)) continue;
                return val;
            }
        }
        return null;
    }

    private boolean matches(String val, String matchString) {
        if (val == null) {
            return false;
        }
        if (matchString == null) {
            return true;
        }
        int idx = val.indexOf(matchString);
        return idx >= 0;
    }

    private List<String> readServiceLoaderMediatorCapabilityMetadata(Bundle bundle, Map<String, Object> customAttributes) throws InvalidSyntaxException {
        String requirementHeader = this.getHeaderFromBundleOrFragment(bundle, "Require-Capability", "osgi.serviceloader");
        if (requirementHeader == null) {
            return null;
        }
        Parameters requirements = OSGiHeader.parseHeader(requirementHeader);
        Map.Entry<String, ? extends Map<String, String>> extenderRequirement = ConsumerHeaderProcessor.findRequirement(requirements, "osgi.extender", "osgi.serviceloader.registrar");
        if (extenderRequirement == null) {
            return null;
        }
        String capabilityHeader = this.getHeaderFromBundleOrFragment(bundle, "Provide-Capability", "osgi.serviceloader");
        Parameters capabilities = capabilityHeader == null ? new Parameters() : OSGiHeader.parseHeader(capabilityHeader);
        ArrayList<String> serviceNames = new ArrayList<String>();
        for (Map.Entry<String, ? extends Map<String, String>> serviceLoaderCapability : ConsumerHeaderProcessor.findAllMetadata(capabilities, "osgi.serviceloader")) {
            for (Map.Entry<String, String> entry : serviceLoaderCapability.getValue().entrySet()) {
                if ("osgi.serviceloader".equals(entry.getKey())) {
                    serviceNames.add(entry.getValue().toString());
                    continue;
                }
                if ("register:".equals(entry.getKey()) && entry.getValue().equals("")) continue;
                customAttributes.put(entry.getKey(), entry.getValue());
            }
        }
        return serviceNames;
    }

    private Hashtable<String, Object> findServiceRegistrationProperties(Dictionary<?, ?> headers, String spiName, String implName) {
        String registerDirective;
        Object capabilityHeader = headers.get("Provide-Capability");
        if (capabilityHeader == null) {
            return null;
        }
        Parameters capabilities = OSGiHeader.parseHeader(capabilityHeader.toString());
        Map.Entry<String, ? extends Map<String, String>> cap = ConsumerHeaderProcessor.findCapability(capabilities, "osgi.serviceloader", spiName);
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        if (cap != null) {
            for (Map.Entry<String, String> entry : cap.getValue().entrySet()) {
                String key = ConsumerHeaderProcessor.removeDuplicateMarker(entry.getKey());
                if ("osgi.serviceloader".equals(key) || key.startsWith(".")) continue;
                properties.put(entry.getKey(), entry.getValue());
            }
        }
        if ((registerDirective = cap.getValue().get("register:")) == null) {
            return properties;
        }
        if ("".equals(registerDirective.trim())) {
            return null;
        }
        if (implName.equals(registerDirective.trim())) {
            return properties;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<URL> getMetaInfServiceURLsFromJar(URL url) {
        ArrayList<URL> urls = new ArrayList<URL>();
        try (JarInputStream jis = null;){
            jis = new JarInputStream(url.openStream());
            JarEntry je = null;
            while ((je = jis.getNextJarEntry()) != null) {
                if (!je.getName().startsWith(METAINF_SERVICES) || je.getName().length() <= METAINF_SERVICES.length() + 1) continue;
                urls.add(new URL("jar:" + url + "!/" + je.getName()));
            }
        }
        catch (IOException e) {
            this.log(Level.SEVERE, "Problem opening embedded jar file: " + url, e);
        }
        return urls;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object registrations) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object registrations) {
        this.activator.unregisterProviderBundle(bundle);
        if (registrations == null) {
            return;
        }
        for (ServiceRegistration reg : (List)registrations) {
            reg.unregister();
            this.log(Level.INFO, "Unregistered: " + reg);
        }
    }

    private void log(Level level, String message) {
        this.activator.log(level, message);
    }

    private void log(Level level, String message, Throwable th) {
        this.activator.log(level, message, th);
    }
}

