/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging.acknowledge;

import com.amazon.sqs.javamessaging.message.SQSMessage;
import javax.jms.JMSException;

public class SQSMessageIdentifier {
    private String queueUrl;
    private String receiptHandle;
    private String sqsMessageId;
    private String groupId;

    public SQSMessageIdentifier(String queueUrl, String receiptHandle, String sqsMessageId) {
        this(queueUrl, receiptHandle, sqsMessageId, null);
    }

    public SQSMessageIdentifier(String queueUrl, String receiptHandle, String sqsMessageId, String groupId) {
        this.queueUrl = queueUrl;
        this.receiptHandle = receiptHandle;
        this.sqsMessageId = sqsMessageId;
        this.groupId = groupId;
        if (this.groupId != null && this.groupId.isEmpty()) {
            this.groupId = null;
        }
    }

    public static SQSMessageIdentifier fromSQSMessage(SQSMessage sqsMessage) throws JMSException {
        return new SQSMessageIdentifier(sqsMessage.getQueueUrl(), sqsMessage.getReceiptHandle(), sqsMessage.getSQSMessageId(), sqsMessage.getSQSMessageGroupId());
    }

    public String getQueueUrl() {
        return this.queueUrl;
    }

    public String getReceiptHandle() {
        return this.receiptHandle;
    }

    public String getSQSMessageID() {
        return this.sqsMessageId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.queueUrl == null ? 0 : this.queueUrl.hashCode());
        result = 31 * result + (this.receiptHandle == null ? 0 : this.receiptHandle.hashCode());
        result = 31 * result + (this.sqsMessageId == null ? 0 : this.sqsMessageId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQSMessageIdentifier other = (SQSMessageIdentifier)obj;
        if (this.queueUrl == null ? other.queueUrl != null : !this.queueUrl.equals(other.queueUrl)) {
            return false;
        }
        if (this.receiptHandle == null ? other.receiptHandle != null : !this.receiptHandle.equals(other.receiptHandle)) {
            return false;
        }
        return !(this.sqsMessageId == null ? other.sqsMessageId != null : !this.sqsMessageId.equals(other.sqsMessageId));
    }

    public String toString() {
        return "SQSMessageIdentifier [queueUrl=" + this.queueUrl + ", receiptHandle=" + this.receiptHandle + ", sqsMessageId=" + this.sqsMessageId + "]";
    }
}

