/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.concurentlocks;

import com.googlecode.concurentlocks.Locks;
import com.googlecode.concurentlocks.ReadWriteUpdateLock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ReentrantReadWriteUpdateLock
implements ReadWriteUpdateLock {
    final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    final Lock updateMutex = new ReentrantLock();
    final ReadLock readLock = new ReadLock();
    final UpdateLock updateLock = new UpdateLock();
    final WriteLock writeLock = new WriteLock();

    @Override
    public Lock updateLock() {
        return this.updateLock;
    }

    @Override
    public Lock readLock() {
        return this.readLock;
    }

    @Override
    public Lock writeLock() {
        return this.writeLock;
    }

    class WriteLock
    implements Lock {
        WriteLock() {
        }

        @Override
        public void lock() {
            this.validatePreconditions();
            Locks.lockAll((Lock[])new Lock[]{ReentrantReadWriteUpdateLock.this.updateLock, ReentrantReadWriteUpdateLock.this.readWriteLock.writeLock()});
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.validatePreconditions();
            Locks.lockInterruptiblyAll((Lock[])new Lock[]{ReentrantReadWriteUpdateLock.this.updateLock, ReentrantReadWriteUpdateLock.this.readWriteLock.writeLock()});
        }

        @Override
        public boolean tryLock() {
            this.validatePreconditions();
            return Locks.tryLockAll((Lock[])new Lock[]{ReentrantReadWriteUpdateLock.this.updateLock, ReentrantReadWriteUpdateLock.this.readWriteLock.writeLock()});
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            this.validatePreconditions();
            return Locks.tryLockAll((long)time, (TimeUnit)unit, (Lock[])new Lock[]{ReentrantReadWriteUpdateLock.this.updateLock, ReentrantReadWriteUpdateLock.this.readWriteLock.writeLock()});
        }

        @Override
        public void unlock() {
            Locks.unlockAll((Lock[])new Lock[]{ReentrantReadWriteUpdateLock.this.readWriteLock.writeLock(), ReentrantReadWriteUpdateLock.this.updateLock});
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException("This lock does not support conditions");
        }

        void validatePreconditions() {
            if (ReentrantReadWriteUpdateLock.this.readLock.holdCount().value > 0) {
                throw new IllegalStateException("Cannot acquire write lock, as this thread previously acquired and must first release the read lock");
            }
        }
    }

    class UpdateLock
    extends HoldCountLock {
        public UpdateLock() {
            super(ReentrantReadWriteUpdateLock.this.updateMutex);
        }

        @Override
        void validatePreconditions() {
            if (ReentrantReadWriteUpdateLock.this.readLock.holdCount().value > 0) {
                throw new IllegalStateException("Cannot acquire update lock, as this thread previously acquired and must first release the read lock");
            }
        }
    }

    class ReadLock
    extends HoldCountLock {
        public ReadLock() {
            super(ReentrantReadWriteUpdateLock.this.readWriteLock.readLock());
        }

        @Override
        void validatePreconditions() {
            if (ReentrantReadWriteUpdateLock.this.updateLock.holdCount().value > 0) {
                throw new IllegalStateException("Cannot acquire read lock, as this thread previously acquired and must first release the update lock");
            }
        }
    }

    static abstract class HoldCountLock
    implements Lock {
        final ThreadLocal<HoldCount> threadHoldCount = new ThreadLocal<HoldCount>(){

            @Override
            protected HoldCount initialValue() {
                return new HoldCount();
            }
        };
        final Lock backingLock;

        public HoldCountLock(Lock backingLock) {
            this.backingLock = backingLock;
        }

        HoldCount holdCount() {
            return this.threadHoldCount.get();
        }

        @Override
        public void lock() {
            this.validatePreconditions();
            this.backingLock.lock();
            ++this.holdCount().value;
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.validatePreconditions();
            this.backingLock.lockInterruptibly();
            ++this.holdCount().value;
        }

        @Override
        public boolean tryLock() {
            this.validatePreconditions();
            if (this.backingLock.tryLock()) {
                ++this.holdCount().value;
                return true;
            }
            return false;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            this.validatePreconditions();
            if (this.backingLock.tryLock(time, unit)) {
                ++this.holdCount().value;
                return true;
            }
            return false;
        }

        @Override
        public void unlock() {
            this.backingLock.unlock();
            --this.holdCount().value;
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException("This lock does not support conditions");
        }

        abstract void validatePreconditions();

        static class HoldCount {
            int value;

            HoldCount() {
            }
        }
    }
}

