/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.io.Serializable;
import java.io.StringWriter;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractRecord;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.sessions.Record;

public abstract class AbstractRecord
extends CoreAbstractRecord
implements Record,
Cloneable,
Serializable,
Map {
    protected Vector<DatabaseField> fields;
    protected Vector values;
    protected DatabaseField lookupField;
    protected int size;
    public static final NoEntry noEntry = new NoEntry();
    protected boolean nullValueInFields;
    protected transient Object sopObject;

    public AbstractRecord() {
        this.fields = new NonSynchronizedVector();
        this.values = new NonSynchronizedVector();
        this.size = 0;
        this.nullValueInFields = false;
    }

    public AbstractRecord(int initialCapacity) {
        this.fields = new NonSynchronizedVector(initialCapacity);
        this.values = new NonSynchronizedVector(initialCapacity);
        this.size = 0;
        this.nullValueInFields = false;
    }

    public AbstractRecord(Vector fields, Vector values) {
        this.fields = fields;
        this.values = values;
        this.nullValueInFields = false;
        this.resetSize();
    }

    public AbstractRecord(Vector fields, Vector values, int size) {
        this.fields = fields;
        this.values = values;
        this.nullValueInFields = false;
        this.size = size;
    }

    protected void resetSize() {
        this.size = this.fields == null ? 0 : this.fields.size();
    }

    public void add(DatabaseField key, Object value) {
        this.fields.add(key);
        this.values.add(value);
        ++this.size;
    }

    @Override
    public void clear() {
        this.fields = new Vector();
        this.values = new Vector();
        this.resetSize();
    }

    public AbstractRecord clone() {
        try {
            AbstractRecord clone = (AbstractRecord)super.clone();
            clone.fields = (Vector)this.fields.clone();
            clone.values = (Vector)this.values.clone();
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String) {
            return this.containsKey((String)key);
        }
        if (key instanceof DatabaseField) {
            return this.containsKey((DatabaseField)key);
        }
        return false;
    }

    public boolean containsKey(String fieldName) {
        return this.containsKey(this.getLookupField(fieldName));
    }

    public boolean containsKey(DatabaseField key) {
        DatabaseField field;
        int index = key.index;
        if (index >= 0 && index < this.size && ((field = this.fields.get(index)) == key || field.equals(key))) {
            return true;
        }
        return this.fields.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getValues().contains(value);
    }

    public Enumeration elements() {
        return this.getValues().elements();
    }

    public Set entrySet() {
        return new EntrySet();
    }

    public Object get(Object key) {
        if (key instanceof String) {
            return this.get((String)key);
        }
        if (key instanceof DatabaseField) {
            return this.get((DatabaseField)key);
        }
        return null;
    }

    public Object get(String fieldName) {
        return this.get(this.getLookupField(fieldName));
    }

    protected DatabaseField getLookupField(String fieldName) {
        if (this.lookupField == null) {
            this.lookupField = new DatabaseField(fieldName);
        } else {
            this.lookupField.resetQualifiedName(fieldName);
        }
        return this.lookupField;
    }

    public Object getIndicatingNoEntry(String fieldName) {
        return this.getIndicatingNoEntry(this.getLookupField(fieldName));
    }

    public Object get(DatabaseField key) {
        DatabaseField field;
        int index = key.index;
        if (index >= 0 && index < this.size && ((field = this.fields.get(index)) == key || field.equals(key))) {
            return this.values.get(index);
        }
        int fieldsIndex = this.fields.indexOf(key);
        if (fieldsIndex >= 0) {
            if (index == -1) {
                key.setIndex(fieldsIndex);
            }
            return this.values.get(fieldsIndex);
        }
        return null;
    }

    public Object getValues(DatabaseField key) {
        return this.get(key);
    }

    public Object getValues(String key) {
        return this.get(key);
    }

    public Object getIndicatingNoEntry(DatabaseField key) {
        DatabaseField field;
        int index = key.index;
        if (index >= 0 && index < this.size && ((field = this.fields.get(index)) == key || field.equals(key))) {
            return this.values.get(index);
        }
        int fieldsIndex = this.fields.indexOf(key);
        if (fieldsIndex >= 0) {
            if (index == -1) {
                key.setIndex(fieldsIndex);
            }
            return this.values.get(fieldsIndex);
        }
        return noEntry;
    }

    public DatabaseField getField(DatabaseField key) {
        DatabaseField field;
        int index = key.index;
        if (index >= 0 && index < this.getFields().size() && ((field = this.getFields().elementAt(index)) == key || field.equals(key))) {
            return field;
        }
        index = 0;
        while (index < this.getFields().size()) {
            field = this.getFields().elementAt(index);
            if (field == key || field.equals(key)) {
                return field;
            }
            ++index;
        }
        return null;
    }

    public Vector<DatabaseField> getFields() {
        return this.fields;
    }

    public Vector getValues() {
        return this.values;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean hasNullValueInFields() {
        return this.nullValueInFields;
    }

    public Enumeration keys() {
        return this.getFields().elements();
    }

    public Set keySet() {
        return new KeySet();
    }

    public void mergeFrom(AbstractRecord row) {
        int index = 0;
        while (index < row.size()) {
            this.put(row.getFields().get(index), row.getValues().get(index));
            ++index;
        }
    }

    public Object put(Object key, Object value) throws ValidationException {
        if (key instanceof String) {
            return this.put((String)key, value);
        }
        if (key instanceof DatabaseField) {
            return this.put((DatabaseField)key, value);
        }
        throw ValidationException.onlyFieldsAreValidKeysForDatabaseRows();
    }

    public Object put(String key, Object value) {
        return this.put(new DatabaseField(key), value);
    }

    public Object put(DatabaseField key, Object value) {
        int index = this.fields.indexOf(key);
        if (index >= 0) {
            return this.values.set(index, value);
        }
        this.add(key, value);
        return null;
    }

    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object key) {
        if (key instanceof String) {
            return this.remove((String)key);
        }
        if (key instanceof DatabaseField) {
            return this.remove((DatabaseField)key);
        }
        return null;
    }

    public Object remove(String fieldName) {
        return this.remove(new DatabaseField(fieldName));
    }

    public Object remove(DatabaseField key) {
        int index = this.getFields().indexOf(key);
        if (index >= 0) {
            this.getFields().removeElementAt(index);
            Object value = this.getValues().elementAt(index);
            this.getValues().removeElementAt(index);
            this.resetSize();
            return value;
        }
        return null;
    }

    public void replaceAt(Object value, int index) {
        this.values.set(index, value);
    }

    public void replaceAt(Object value, DatabaseField key) {
        int fieldsIndex;
        DatabaseField field;
        int index = key.index;
        if (index >= 0 && index < this.size && ((field = this.fields.get(index)) == key || field.equals(key))) {
            this.values.set(index, value);
        }
        if ((fieldsIndex = this.fields.indexOf(key)) >= 0) {
            if (index == -1) {
                key.setIndex(fieldsIndex);
            }
            this.values.set(fieldsIndex, value);
        }
    }

    protected void setFields(Vector fields) {
        this.fields = fields;
        this.resetSize();
    }

    public void setNullValueInFields(boolean nullValueInFields) {
        this.nullValueInFields = nullValueInFields;
    }

    protected void setValues(Vector values) {
        this.values = values;
    }

    @Override
    public int size() {
        return this.fields.size();
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write(Helper.getShortClassName(this.getClass()));
        writer.write("(");
        int index = 0;
        while (index < this.getFields().size()) {
            writer.write(Helper.cr());
            writer.write("\t");
            writer.write(String.valueOf(this.getFields().elementAt(index)));
            writer.write(" => ");
            writer.write(String.valueOf(this.getValues().elementAt(index)));
            ++index;
        }
        if (this.sopObject != null) {
            writer.write(Helper.cr());
            writer.write(" sopObject = ");
            writer.write(this.sopObject.toString());
        }
        writer.write(")");
        return writer.toString();
    }

    public Collection values() {
        return new ValuesSet();
    }

    public boolean hasSopObject() {
        return this.sopObject != null;
    }

    public Object getSopObject() {
        return this.sopObject;
    }

    public void setSopObject(Object sopObject) {
        this.sopObject = sopObject;
    }

    protected class EntrySet
    extends AbstractSet {
        protected EntrySet() {
        }

        @Override
        public Iterator iterator() {
            return new RecordEntryIterator();
        }

        @Override
        public int size() {
            return AbstractRecord.this.size();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            return AbstractRecord.this.containsKey(((Map.Entry)object).getKey());
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            AbstractRecord.this.remove(((Map.Entry)object).getKey());
            return true;
        }

        @Override
        public void clear() {
            AbstractRecord.this.clear();
        }
    }

    protected class KeySet
    extends EntrySet {
        protected KeySet() {
        }

        @Override
        public Iterator iterator() {
            return new RecordKeyIterator();
        }

        @Override
        public boolean contains(Object object) {
            return AbstractRecord.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return AbstractRecord.this.remove(object) != null;
        }
    }

    public static class NoEntry {
        private NoEntry() {
        }
    }

    protected static class RecordEntry
    implements Map.Entry {
        Object key;
        Object value;

        public RecordEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return this.compare(this.key, entry.getKey()) && this.compare(this.value, entry.getValue());
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private boolean compare(Object object1, Object object2) {
            return object1 == null ? object2 == null : object1.equals(object2);
        }
    }

    protected class RecordEntryIterator
    implements Iterator {
        int index = 0;

        RecordEntryIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < AbstractRecord.this.size();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.index;
            return new RecordEntry(AbstractRecord.this.getFields().get(this.index - 1), AbstractRecord.this.getValues().get(this.index - 1));
        }

        @Override
        public void remove() {
            if (this.index >= AbstractRecord.this.size()) {
                throw new IllegalStateException();
            }
            AbstractRecord.this.remove(AbstractRecord.this.getFields().get(this.index));
        }
    }

    protected class RecordKeyIterator
    extends RecordEntryIterator {
        protected RecordKeyIterator() {
        }

        @Override
        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.index;
            return AbstractRecord.this.getFields().get(this.index - 1);
        }
    }

    protected class RecordValuesIterator
    extends RecordEntryIterator {
        protected RecordValuesIterator() {
        }

        @Override
        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.index;
            return AbstractRecord.this.getValues().get(this.index - 1);
        }
    }

    protected class ValuesSet
    extends EntrySet {
        protected ValuesSet() {
        }

        @Override
        public Iterator iterator() {
            return new RecordValuesIterator();
        }

        @Override
        public boolean contains(Object object) {
            return AbstractRecord.this.contains(object);
        }

        @Override
        public boolean remove(Object object) {
            int index = AbstractRecord.this.getValues().indexOf(object);
            if (index == -1) {
                return false;
            }
            AbstractRecord.this.remove(AbstractRecord.this.getFields().get(index));
            return true;
        }
    }
}

