/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.aws.sqs;

import java.util.Objects;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemIdFilterProcessor
implements AsyncProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SystemIdFilterProcessor.class);
    private final String systemId;

    public SystemIdFilterProcessor(String systemId) {
        this.systemId = Objects.requireNonNull(systemId);
    }

    public void process(Exchange exchange) throws Exception {
        throw new UnsupportedOperationException("This processor must be invoked using the async interface.");
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        String targettedSystemId = (String)exchange.getIn().getHeader("SystemId");
        if (targettedSystemId != null && !this.systemId.equals(targettedSystemId)) {
            LOG.info("Directed RPCs are not supported with SQS. The message targeted to %s, but our system id is %s.Processing the message anyways.");
        }
        callback.done(false);
        return false;
    }
}

