/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.aws.sqs;

import java.util.Objects;
import org.apache.camel.Exchange;
import org.opennms.core.ipc.common.aws.sqs.AmazonSQSManager;
import org.opennms.core.ipc.common.aws.sqs.AmazonSQSQueueException;
import org.opennms.core.rpc.camel.CamelRpcClientPreProcessor;
import org.opennms.core.rpc.camel.CamelRpcRequest;

public class AmazonSQSClientPreProcessor
extends CamelRpcClientPreProcessor {
    private final AmazonSQSManager sqsManager;

    public AmazonSQSClientPreProcessor(AmazonSQSManager sqsManager) {
        this.sqsManager = Objects.requireNonNull(sqsManager);
    }

    public void process(Exchange exchange) throws AmazonSQSQueueException {
        CamelRpcRequest wrapper = (CamelRpcRequest)exchange.getIn().getBody(CamelRpcRequest.class);
        String requestQueueName = this.sqsManager.getRpcRequestQueueNameAndCreateIfNecessary(wrapper.getModule().getId(), wrapper.getRequest().getLocation());
        String replyQueueName = this.sqsManager.getRpcReplyQueueNameAndCreateIfNecessary(wrapper.getModule().getId(), wrapper.getRequest().getLocation());
        exchange.getIn().setHeader("JmsQueueName", (Object)requestQueueName);
        exchange.getIn().setHeader("JmsReplyToQueueName", (Object)replyQueueName);
        exchange.getIn().setHeader("CamelJmsRequestTimeout", (Object)(wrapper.getRequest().getTimeToLiveMs() != null ? wrapper.getRequest().getTimeToLiveMs() : this.CAMEL_JMS_REQUEST_TIMEOUT));
        if (wrapper.getRequest().getSystemId() != null) {
            exchange.getIn().setHeader("SystemId", (Object)wrapper.getRequest().getSystemId());
        }
        String request = wrapper.getModule().marshalRequest(wrapper.getRequest());
        exchange.getIn().setBody((Object)request);
    }
}

