/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.proxy.strategy;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.opennms.core.rpc.api.RpcClient;
import org.opennms.netmgt.icmp.proxy.PingRequestBuilder;
import org.opennms.netmgt.icmp.proxy.PingRequestDTO;
import org.opennms.netmgt.icmp.proxy.PingResponseDTO;
import org.opennms.netmgt.icmp.proxy.PingSequence;
import org.opennms.netmgt.icmp.proxy.PingSummary;
import org.opennms.netmgt.icmp.proxy.strategy.ExecutionStrategy;
import org.opennms.netmgt.icmp.proxy.strategy.SinglePingExecutionStrategy;

public class MultiplePingExecutionStrategy
implements ExecutionStrategy {
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private final PingRequestBuilder.Callback callback;
    private final RpcClient<PingRequestDTO, PingResponseDTO> client;
    private int numberOfRequests;

    public MultiplePingExecutionStrategy(RpcClient<PingRequestDTO, PingResponseDTO> client, int numberOfRequests, PingRequestBuilder.Callback callback) {
        this.client = Objects.requireNonNull(client);
        this.numberOfRequests = numberOfRequests;
        this.callback = Objects.requireNonNull(callback);
    }

    @Override
    public CompletableFuture<PingSummary> execute(PingRequestDTO requestDTO) {
        CancelableCompletableFuture completableFuture = new CancelableCompletableFuture();
        completableFuture.startCancelableExecution(new PingTask(requestDTO, completableFuture));
        return completableFuture;
    }

    private class PingTask
    implements Callable<PingSummary> {
        private final PingRequestDTO requestDTO;
        private final CompletableFuture<PingSummary> completableFuture;

        private PingTask(PingRequestDTO requestDTO, CompletableFuture<PingSummary> completableFuture) {
            this.requestDTO = Objects.requireNonNull(requestDTO);
            this.completableFuture = Objects.requireNonNull(completableFuture);
        }

        @Override
        public PingSummary call() throws Exception {
            PingSummary pingSummary = new PingSummary(this.requestDTO.toPingRequest(), MultiplePingExecutionStrategy.this.numberOfRequests);
            for (int sequenceId = 1; sequenceId <= MultiplePingExecutionStrategy.this.numberOfRequests; ++sequenceId) {
                PingSequence newSequence;
                if (this.completableFuture.isCancelled()) {
                    return pingSummary;
                }
                this.reportProgress(null, pingSummary);
                CompletableFuture<PingSummary> singlePingFuture = new SinglePingExecutionStrategy((RpcClient<PingRequestDTO, PingResponseDTO>)MultiplePingExecutionStrategy.this.client).execute(this.requestDTO);
                try {
                    PingSummary singlePingSummary = singlePingFuture.get(this.requestDTO.getTimeToLiveMs(), TimeUnit.MILLISECONDS);
                    newSequence = new PingSequence(sequenceId, singlePingSummary.getSequence(0).getResponse());
                    pingSummary.addSequence(newSequence);
                    this.reportProgress(newSequence, pingSummary);
                    continue;
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    newSequence = new PingSequence(sequenceId, e);
                    pingSummary.addSequence(newSequence);
                    this.reportProgress(newSequence, pingSummary);
                }
            }
            this.completableFuture.complete(pingSummary);
            return pingSummary;
        }

        private void reportProgress(PingSequence newSequence, PingSummary summary) {
            if (MultiplePingExecutionStrategy.this.callback != null) {
                MultiplePingExecutionStrategy.this.callback.onUpdate(newSequence, summary);
            }
        }
    }

    private static class CancelableCompletableFuture
    extends CompletableFuture {
        private Future<?> future;
        private ExecutorService executor;

        private CancelableCompletableFuture() {
        }

        public boolean complete(Object value) {
            try {
                boolean bl = super.complete(value);
                return bl;
            }
            finally {
                this.executor.shutdown();
            }
        }

        @Override
        public boolean completeExceptionally(Throwable ex) {
            try {
                boolean bl = super.completeExceptionally(ex);
                return bl;
            }
            finally {
                this.executor.shutdown();
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            try {
                boolean bl = this.future.cancel(mayInterruptIfRunning);
                return bl;
            }
            finally {
                super.cancel(mayInterruptIfRunning);
            }
        }

        public void startCancelableExecution(Callable<?> task) {
            this.executor = Executors.newSingleThreadExecutor(runnable -> new Thread(null, runnable, "icmp-proxy-pool-" + poolNumber.getAndIncrement()));
            this.future = this.executor.submit(task);
        }
    }
}

