/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import com.googlecode.concurentlocks.ReadWriteUpdateLock;
import com.googlecode.concurentlocks.ReentrantReadWriteUpdateLock;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import org.apache.commons.io.IOUtils;
import org.opennms.core.spring.FileReloadCallback;
import org.opennms.core.spring.FileReloadContainer;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.SnmpConfigManager;
import org.opennms.netmgt.config.SnmpEventInfo;
import org.opennms.netmgt.config.api.SnmpAgentConfigFactory;
import org.opennms.netmgt.config.snmp.AddressSnmpConfigVisitor;
import org.opennms.netmgt.config.snmp.Definition;
import org.opennms.netmgt.config.snmp.SnmpConfig;
import org.opennms.netmgt.config.snmp.SnmpConfigVisitor;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class SnmpPeerFactory
implements SnmpAgentConfigFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpPeerFactory.class);
    private static final int VERSION_UNSPECIFIED = -1;
    private static File s_configFile;
    private static SnmpPeerFactory s_singleton;
    private static AtomicBoolean s_loaded;
    private final ReadWriteUpdateLock m_globalLock = new ReentrantReadWriteUpdateLock();
    private final Lock m_readLock = this.m_globalLock.updateLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    private SnmpConfig m_config;
    private FileReloadContainer<SnmpConfig> m_container;
    private FileReloadCallback<SnmpConfig> m_callback;

    public SnmpPeerFactory(Resource resource) {
        LOG.debug("creating new instance for resource {}: {}", (Object)resource, (Object)this);
        SnmpConfig config = (SnmpConfig)JaxbUtils.unmarshal(SnmpConfig.class, (Resource)resource);
        try {
            File file = resource.getFile();
            if (file != null) {
                this.m_callback = new FileReloadCallback<SnmpConfig>(){

                    public SnmpConfig reload(SnmpConfig object, Resource resource) throws IOException {
                        return (SnmpConfig)JaxbUtils.unmarshal(SnmpConfig.class, (Resource)resource);
                    }
                };
                this.m_container = new FileReloadContainer((Object)config, resource, this.m_callback);
                return;
            }
        }
        catch (IOException e) {
            LOG.debug("No file associated with resource {}, skipping reload container initialization. Reason: ", (Object)resource, (Object)e.getMessage());
        }
        this.m_config = config;
    }

    protected Lock getReadLock() {
        return this.m_readLock;
    }

    protected Lock getWriteLock() {
        return this.m_writeLock;
    }

    public static synchronized void init() throws IOException {
        if (!s_loaded.get()) {
            File cfgFile = SnmpPeerFactory.getFile();
            LOG.debug("init: config file path: {}", (Object)cfgFile.getPath());
            FileSystemResource resource = new FileSystemResource(cfgFile);
            s_singleton = new SnmpPeerFactory((Resource)resource);
            s_loaded.set(true);
        }
    }

    public static synchronized SnmpPeerFactory getInstance() {
        if (!s_loaded.get()) {
            try {
                SnmpPeerFactory.init();
            }
            catch (IOException e) {
                LOG.error("Failed to initialize SnmpPeerFactory instance!", (Throwable)e);
            }
        }
        return s_singleton;
    }

    public static synchronized void setInstance(SnmpPeerFactory singleton) {
        LOG.debug("setting new singleton instance {}", (Object)singleton);
        s_singleton = singleton;
        s_loaded.set(true);
    }

    public static synchronized File getFile() throws IOException {
        if (s_configFile == null) {
            SnmpPeerFactory.setFile(ConfigFileConstants.getFile((int)ConfigFileConstants.SNMP_CONF_FILE_NAME));
        }
        return s_configFile;
    }

    public static synchronized void setFile(File configFile) {
        File oldFile = s_configFile;
        s_configFile = configFile;
        if (oldFile == null || s_configFile == null || !oldFile.equals(s_configFile)) {
            s_singleton = null;
            s_loaded.set(false);
        }
    }

    public void saveCurrent() throws IOException {
        this.saveToFile(SnmpPeerFactory.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile(File file) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        this.getWriteLock().lock();
        String marshalledConfig = this.getSnmpConfigAsString();
        FileOutputStream out = null;
        OutputStreamWriter fileWriter = null;
        try {
            if (marshalledConfig != null) {
                out = new FileOutputStream(file);
                fileWriter = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
                fileWriter.write(marshalledConfig);
                ((Writer)fileWriter).flush();
                ((Writer)fileWriter).close();
                if (this.m_container != null) {
                    this.m_container.reload();
                }
            }
        }
        finally {
            IOUtils.closeQuietly(fileWriter);
            IOUtils.closeQuietly(out);
            this.getWriteLock().unlock();
        }
    }

    public SnmpAgentConfig getAgentConfig(InetAddress agentAddress) {
        return this.getAgentConfig(agentAddress, null, -1);
    }

    public SnmpAgentConfig getAgentConfig(InetAddress agentAddress, String location) {
        return this.getAgentConfig(agentAddress, location, -1);
    }

    public SnmpAgentConfig getAgentConfig(InetAddress agentInetAddress, int requestedSnmpVersion) {
        return this.getAgentConfig(agentInetAddress, null, requestedSnmpVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnmpAgentConfig getAgentConfig(InetAddress agentInetAddress, String location, int requestedSnmpVersion) {
        this.getReadLock().lock();
        try {
            if (this.getSnmpConfig() == null) {
                SnmpAgentConfig agentConfig = new SnmpAgentConfig(agentInetAddress);
                if (requestedSnmpVersion == -1) {
                    agentConfig.setVersion(1);
                } else {
                    agentConfig.setVersion(requestedSnmpVersion);
                }
                SnmpAgentConfig snmpAgentConfig = agentConfig;
                return snmpAgentConfig;
            }
            SnmpAgentConfig agentConfig = new SnmpAgentConfig(agentInetAddress);
            this.setSnmpAgentConfig(agentConfig, new Definition(), requestedSnmpVersion);
            AddressSnmpConfigVisitor visitor = new AddressSnmpConfigVisitor(agentInetAddress, location);
            this.getSnmpConfig().visit((SnmpConfigVisitor)visitor);
            Definition matchingDef = visitor.getDefinition();
            if (matchingDef != null) {
                this.setSnmpAgentConfig(agentConfig, matchingDef, requestedSnmpVersion);
            }
            SnmpAgentConfig snmpAgentConfig = agentConfig;
            return snmpAgentConfig;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    private void setSnmpAgentConfig(SnmpAgentConfig agentConfig, Definition def, int requestedSnmpVersion) {
        int version = this.getVersionCode(def, this.getSnmpConfig(), requestedSnmpVersion);
        this.setCommonAttributes(agentConfig, def, version);
        agentConfig.setSecurityLevel(def.getSecurityLevel().intValue());
        agentConfig.setSecurityName(def.getSecurityName());
        agentConfig.setAuthProtocol(def.getAuthProtocol());
        agentConfig.setAuthPassPhrase(def.getAuthPassphrase());
        agentConfig.setPrivPassPhrase(def.getPrivacyPassphrase());
        agentConfig.setPrivProtocol(def.getPrivacyProtocol());
        agentConfig.setReadCommunity(def.getReadCommunity());
        agentConfig.setWriteCommunity(def.getWriteCommunity());
        agentConfig.setContextName(def.getContextName());
        agentConfig.setEngineId(def.getEngineId());
        agentConfig.setContextEngineId(def.getContextEngineId());
        agentConfig.setEnterpriseId(def.getEnterpriseId());
    }

    private void setCommonAttributes(SnmpAgentConfig agentConfig, Definition def, int version) {
        agentConfig.setVersion(version);
        agentConfig.setPort(def.getPort().intValue());
        agentConfig.setRetries(def.getRetry().intValue());
        agentConfig.setTimeout(def.getTimeout().intValue());
        agentConfig.setMaxRequestSize(def.getMaxRequestSize().intValue());
        agentConfig.setMaxVarsPerPdu(def.getMaxVarsPerPdu().intValue());
        agentConfig.setMaxRepetitions(def.getMaxRepetitions().intValue());
        agentConfig.setTTL(def.getTTL());
        InetAddress proxyHost = InetAddressUtils.addr((String)def.getProxyHost());
        if (proxyHost != null) {
            agentConfig.setProxyFor(agentConfig.getAddress());
            agentConfig.setAddress(proxyHost);
        }
    }

    public int getVersionCode(Definition def, SnmpConfig config, int requestedSnmpVersion) {
        if (requestedSnmpVersion == -1) {
            if (def.getVersion() == null) {
                if (config.getVersion() == null) {
                    return 1;
                }
                return SnmpConfiguration.stringToVersion((String)config.getVersion());
            }
            return SnmpConfiguration.stringToVersion((String)def.getVersion());
        }
        return requestedSnmpVersion;
    }

    public SnmpConfig getSnmpConfig() {
        this.getReadLock().lock();
        try {
            if (this.m_container == null) {
                SnmpConfig snmpConfig = this.m_config;
                return snmpConfig;
            }
            SnmpConfig snmpConfig = (SnmpConfig)this.m_container.getObject();
            return snmpConfig;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public void define(SnmpEventInfo info) {
        this.getWriteLock().lock();
        try {
            SnmpConfigManager mgr = new SnmpConfigManager(this.getSnmpConfig());
            mgr.mergeIntoConfig(info.createDef());
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    public String getSnmpConfigAsString() {
        String marshalledConfig = null;
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            JaxbUtils.marshal((Object)this.getSnmpConfig(), (Writer)writer);
            marshalledConfig = writer.toString();
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        return marshalledConfig;
    }

    static {
        s_singleton = null;
        s_loaded = new AtomicBoolean(false);
    }
}

