/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.io.resource.internal;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.linkedin.util.clock.Timespan;
import org.linkedin.util.io.PathUtils;
import org.linkedin.util.io.resource.ResourceFilter;
import org.linkedin.util.io.resource.URLResource;
import org.linkedin.util.io.resource.UnsupportedURIException;
import org.linkedin.util.io.resource.internal.InternalResource;
import org.linkedin.util.io.resource.internal.InternalResourceProvider;
import org.linkedin.util.io.resource.internal.PathBasedResourceProvider;

public class URLResourceProvider
extends PathBasedResourceProvider {
    private final URL _baseURL;
    private final Timespan _connectTimeout;
    private final Timespan _readTimeout;

    public URLResourceProvider(URL baseURL) throws UnsupportedURIException, URISyntaxException {
        this(baseURL, "/");
    }

    public URLResourceProvider(URL baseURL, Timespan connectTimeout, Timespan readTimeout) throws UnsupportedURIException, URISyntaxException {
        this(baseURL, "/", connectTimeout, readTimeout);
    }

    public URLResourceProvider(URL baseURL, String root) throws UnsupportedURIException, URISyntaxException {
        this(baseURL, root, URLResource.DEFAULT_CONNECT_TIMEOUT, URLResource.DEFAULT_READ_TIMEOUT);
    }

    public URLResourceProvider(URL baseURL, String root, Timespan connectTimeout, Timespan readTimeout) throws UnsupportedURIException, URISyntaxException {
        super(PathUtils.addPaths(baseURL.getPath(), root));
        if (baseURL.toURI().isOpaque()) {
            throw new UnsupportedURIException(baseURL + " is opaque");
        }
        this._baseURL = baseURL;
        this._connectTimeout = connectTimeout;
        this._readTimeout = readTimeout;
    }

    @Override
    public InternalResourceProvider doCreateResourceProvider(String rootPath) {
        try {
            return new URLResourceProvider(this._baseURL, this.getFullPath(rootPath));
        }
        catch (UnsupportedURIException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InternalResource doBuildResource(String path) {
        try {
            URI uri = this._baseURL.toURI();
            URI newURI = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), this.getFullPath(path), null, null);
            return new URLResource(this, path, newURI.toURL(), this._connectTimeout, this._readTimeout);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean doList(String path, ResourceFilter filter) {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        URLResourceProvider that = (URLResourceProvider)o;
        return this._baseURL.equals(that._baseURL);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this._baseURL.hashCode();
        return result;
    }
}

