/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.reactor;

import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;

public class FlowController
extends BaseHandler {
    private int drained;
    private int window;

    public FlowController(int window) {
        if (window <= 1) {
            throw new IllegalArgumentException();
        }
        this.window = window;
        this.drained = 0;
    }

    public FlowController() {
        this(1024);
    }

    private void topup(Receiver link2, int window) {
        int delta = window - link2.getCredit();
        link2.flow(delta);
    }

    @Override
    public void onUnhandled(Event event) {
        int window = this.window;
        Link link2 = event.getLink();
        switch (event.getType()) {
            case LINK_LOCAL_OPEN: 
            case LINK_REMOTE_OPEN: 
            case LINK_FLOW: 
            case DELIVERY: {
                if (!(link2 instanceof Receiver)) break;
                this.drained += link2.drained();
                if (this.drained != 0) break;
                this.topup((Receiver)link2, window);
                break;
            }
        }
    }
}

