/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Decimal128;
import org.apache.qpid.proton.amqp.Decimal32;
import org.apache.qpid.proton.amqp.Decimal64;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.apache.qpid.proton.codec.AMQPType;
import org.apache.qpid.proton.codec.ArrayType;
import org.apache.qpid.proton.codec.BigIntegerType;
import org.apache.qpid.proton.codec.BinaryType;
import org.apache.qpid.proton.codec.BooleanType;
import org.apache.qpid.proton.codec.ByteBufferEncoder;
import org.apache.qpid.proton.codec.ByteType;
import org.apache.qpid.proton.codec.CharacterType;
import org.apache.qpid.proton.codec.Decimal128Type;
import org.apache.qpid.proton.codec.Decimal32Type;
import org.apache.qpid.proton.codec.Decimal64Type;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.DoubleType;
import org.apache.qpid.proton.codec.DynamicDescribedType;
import org.apache.qpid.proton.codec.FloatType;
import org.apache.qpid.proton.codec.IntegerType;
import org.apache.qpid.proton.codec.ListType;
import org.apache.qpid.proton.codec.LongType;
import org.apache.qpid.proton.codec.MapType;
import org.apache.qpid.proton.codec.NullType;
import org.apache.qpid.proton.codec.ShortType;
import org.apache.qpid.proton.codec.StringType;
import org.apache.qpid.proton.codec.SymbolType;
import org.apache.qpid.proton.codec.TimestampType;
import org.apache.qpid.proton.codec.UUIDType;
import org.apache.qpid.proton.codec.UnsignedByteType;
import org.apache.qpid.proton.codec.UnsignedIntegerType;
import org.apache.qpid.proton.codec.UnsignedLongType;
import org.apache.qpid.proton.codec.UnsignedShortType;
import org.apache.qpid.proton.codec.WritableBuffer;

public final class EncoderImpl
implements ByteBufferEncoder {
    private static final byte DESCRIBED_TYPE_OP = 0;
    private WritableBuffer _buffer;
    private final Map<Class, AMQPType> _typeRegistry = new HashMap<Class, AMQPType>();
    private Map<Object, AMQPType> _describedDescriptorRegistry = new HashMap<Object, AMQPType>();
    private Map<Class, AMQPType> _describedTypesClassRegistry = new HashMap<Class, AMQPType>();
    private final NullType _nullType;
    private final BooleanType _booleanType;
    private final ByteType _byteType;
    private final UnsignedByteType _unsignedByteType;
    private final ShortType _shortType;
    private final UnsignedShortType _unsignedShortType;
    private final IntegerType _integerType;
    private final UnsignedIntegerType _unsignedIntegerType;
    private final LongType _longType;
    private final UnsignedLongType _unsignedLongType;
    private final BigIntegerType _bigIntegerType;
    private final CharacterType _characterType;
    private final FloatType _floatType;
    private final DoubleType _doubleType;
    private final TimestampType _timestampType;
    private final UUIDType _uuidType;
    private final Decimal32Type _decimal32Type;
    private final Decimal64Type _decimal64Type;
    private final Decimal128Type _decimal128Type;
    private final BinaryType _binaryType;
    private final SymbolType _symbolType;
    private final StringType _stringType;
    private final ListType _listType;
    private final MapType _mapType;
    private final ArrayType _arrayType;

    EncoderImpl(ByteBuffer buffer, DecoderImpl decoder) {
        this(decoder);
        this.setByteBuffer(buffer);
    }

    public EncoderImpl(DecoderImpl decoder) {
        this._nullType = new NullType(this, decoder);
        this._booleanType = new BooleanType(this, decoder);
        this._byteType = new ByteType(this, decoder);
        this._unsignedByteType = new UnsignedByteType(this, decoder);
        this._shortType = new ShortType(this, decoder);
        this._unsignedShortType = new UnsignedShortType(this, decoder);
        this._integerType = new IntegerType(this, decoder);
        this._unsignedIntegerType = new UnsignedIntegerType(this, decoder);
        this._longType = new LongType(this, decoder);
        this._unsignedLongType = new UnsignedLongType(this, decoder);
        this._bigIntegerType = new BigIntegerType(this, decoder);
        this._characterType = new CharacterType(this, decoder);
        this._floatType = new FloatType(this, decoder);
        this._doubleType = new DoubleType(this, decoder);
        this._timestampType = new TimestampType(this, decoder);
        this._uuidType = new UUIDType(this, decoder);
        this._decimal32Type = new Decimal32Type(this, decoder);
        this._decimal64Type = new Decimal64Type(this, decoder);
        this._decimal128Type = new Decimal128Type(this, decoder);
        this._binaryType = new BinaryType(this, decoder);
        this._symbolType = new SymbolType(this, decoder);
        this._stringType = new StringType(this, decoder);
        this._listType = new ListType(this, decoder);
        this._mapType = new MapType(this, decoder);
        this._arrayType = new ArrayType(this, decoder, this._booleanType, this._byteType, this._shortType, this._integerType, this._longType, this._floatType, this._doubleType, this._characterType);
    }

    @Override
    public void setByteBuffer(ByteBuffer buf) {
        this._buffer = new WritableBuffer.ByteBufferWrapper(buf);
    }

    public void setByteBuffer(WritableBuffer buf) {
        this._buffer = buf;
    }

    @Override
    public AMQPType getType(Object element) {
        if (element instanceof DescribedType) {
            Object descriptor = ((DescribedType)element).getDescriptor();
            AMQPType amqpType = this._describedDescriptorRegistry.get(descriptor);
            if (amqpType == null) {
                amqpType = new DynamicDescribedType(this, descriptor);
                this._describedDescriptorRegistry.put(descriptor, amqpType);
            }
            return amqpType;
        }
        return this.getTypeFromClass(element == null ? Void.class : element.getClass());
    }

    public AMQPType getTypeFromClass(Class clazz) {
        AMQPType amqpType = this._typeRegistry.get(clazz);
        if (amqpType == null) {
            if (clazz.isArray()) {
                amqpType = this._arrayType;
            } else if (List.class.isAssignableFrom(clazz)) {
                amqpType = this._listType;
            } else if (Map.class.isAssignableFrom(clazz)) {
                amqpType = this._mapType;
            } else if (DescribedType.class.isAssignableFrom(clazz)) {
                amqpType = this._describedTypesClassRegistry.get(clazz);
            }
            this._typeRegistry.put(clazz, amqpType);
        }
        return amqpType;
    }

    @Override
    public <V> void register(AMQPType<V> type) {
        this.register(type.getTypeClass(), type);
    }

    <T> void register(Class<T> clazz, AMQPType<T> type) {
        this._typeRegistry.put(clazz, type);
    }

    public void registerDescribedType(Class clazz, Object descriptor) {
        AMQPType type = this._describedDescriptorRegistry.get(descriptor);
        if (type == null) {
            type = new DynamicDescribedType(this, descriptor);
            this._describedDescriptorRegistry.put(descriptor, type);
        }
        this._describedTypesClassRegistry.put(clazz, type);
    }

    @Override
    public void writeNull() {
        this._nullType.write();
    }

    @Override
    public void writeBoolean(boolean bool) {
        this._booleanType.writeValue(bool);
    }

    @Override
    public void writeBoolean(Boolean bool) {
        if (bool == null) {
            this.writeNull();
        } else {
            this._booleanType.write(bool);
        }
    }

    @Override
    public void writeUnsignedByte(UnsignedByte ubyte) {
        if (ubyte == null) {
            this.writeNull();
        } else {
            this._unsignedByteType.write(ubyte);
        }
    }

    @Override
    public void writeUnsignedShort(UnsignedShort ushort) {
        if (ushort == null) {
            this.writeNull();
        } else {
            this._unsignedShortType.write(ushort);
        }
    }

    @Override
    public void writeUnsignedInteger(UnsignedInteger uint) {
        if (uint == null) {
            this.writeNull();
        } else {
            this._unsignedIntegerType.write(uint);
        }
    }

    @Override
    public void writeUnsignedLong(UnsignedLong ulong) {
        if (ulong == null) {
            this.writeNull();
        } else {
            this._unsignedLongType.write(ulong);
        }
    }

    @Override
    public void writeByte(byte b) {
        this._byteType.write(b);
    }

    @Override
    public void writeByte(Byte b) {
        if (b == null) {
            this.writeNull();
        } else {
            this.writeByte((byte)b);
        }
    }

    @Override
    public void writeShort(short s) {
        this._shortType.write(s);
    }

    @Override
    public void writeShort(Short s) {
        if (s == null) {
            this.writeNull();
        } else {
            this.writeShort((short)s);
        }
    }

    @Override
    public void writeInteger(int i) {
        this._integerType.write(i);
    }

    @Override
    public void writeInteger(Integer i) {
        if (i == null) {
            this.writeNull();
        } else {
            this.writeInteger((int)i);
        }
    }

    @Override
    public void writeLong(long l) {
        this._longType.write(l);
    }

    @Override
    public void writeLong(Long l) {
        if (l == null) {
            this.writeNull();
        } else {
            this.writeLong((long)l);
        }
    }

    @Override
    public void writeFloat(float f) {
        this._floatType.write(f);
    }

    @Override
    public void writeFloat(Float f) {
        if (f == null) {
            this.writeNull();
        } else {
            this.writeFloat(f.floatValue());
        }
    }

    @Override
    public void writeDouble(double d) {
        this._doubleType.write(d);
    }

    @Override
    public void writeDouble(Double d) {
        if (d == null) {
            this.writeNull();
        } else {
            this.writeDouble((double)d);
        }
    }

    @Override
    public void writeDecimal32(Decimal32 d) {
        if (d == null) {
            this.writeNull();
        } else {
            this._decimal32Type.write(d);
        }
    }

    @Override
    public void writeDecimal64(Decimal64 d) {
        if (d == null) {
            this.writeNull();
        } else {
            this._decimal64Type.write(d);
        }
    }

    @Override
    public void writeDecimal128(Decimal128 d) {
        if (d == null) {
            this.writeNull();
        } else {
            this._decimal128Type.write(d);
        }
    }

    @Override
    public void writeCharacter(char c) {
        this._characterType.write(c);
    }

    @Override
    public void writeCharacter(Character c) {
        if (c == null) {
            this.writeNull();
        } else {
            this.writeCharacter(c.charValue());
        }
    }

    @Override
    public void writeTimestamp(long d) {
        this._timestampType.write(d);
    }

    @Override
    public void writeTimestamp(Date d) {
        if (d == null) {
            this.writeNull();
        } else {
            this.writeTimestamp(d.getTime());
        }
    }

    @Override
    public void writeUUID(UUID uuid) {
        if (uuid == null) {
            this.writeNull();
        } else {
            this._uuidType.write(uuid);
        }
    }

    @Override
    public void writeBinary(Binary b) {
        if (b == null) {
            this.writeNull();
        } else {
            this._binaryType.write(b);
        }
    }

    @Override
    public void writeString(String s) {
        if (s == null) {
            this.writeNull();
        } else {
            this._stringType.write(s);
        }
    }

    @Override
    public void writeSymbol(Symbol s) {
        if (s == null) {
            this.writeNull();
        } else {
            this._symbolType.write(s);
        }
    }

    @Override
    public void writeList(List l) {
        if (l == null) {
            this.writeNull();
        } else {
            this._listType.write(l);
        }
    }

    @Override
    public void writeMap(Map m) {
        if (m == null) {
            this.writeNull();
        } else {
            this._mapType.write(m);
        }
    }

    @Override
    public void writeDescribedType(DescribedType d) {
        if (d == null) {
            this.writeNull();
        } else {
            this._buffer.put((byte)0);
            this.writeObject(d.getDescriptor());
            this.writeObject(d.getDescribed());
        }
    }

    @Override
    public void writeArray(boolean[] a) {
        if (a == null) {
            this.writeNull();
        } else {
            this._arrayType.write(a);
        }
    }

    @Override
    public void writeArray(byte[] a) {
        if (a == null) {
            this.writeNull();
        } else {
            this._arrayType.write(a);
        }
    }

    @Override
    public void writeArray(short[] a) {
        if (a == null) {
            this.writeNull();
        } else {
            this._arrayType.write(a);
        }
    }

    @Override
    public void writeArray(int[] a) {
        if (a == null) {
            this.writeNull();
        } else {
            this._arrayType.write(a);
        }
    }

    @Override
    public void writeArray(long[] a) {
        if (a == null) {
            this.writeNull();
        } else {
            this._arrayType.write(a);
        }
    }

    @Override
    public void writeArray(float[] a) {
        if (a == null) {
            this.writeNull();
        } else {
            this._arrayType.write(a);
        }
    }

    @Override
    public void writeArray(double[] a) {
        if (a == null) {
            this.writeNull();
        } else {
            this._arrayType.write(a);
        }
    }

    @Override
    public void writeArray(char[] a) {
        if (a == null) {
            this.writeNull();
        } else {
            this._arrayType.write(a);
        }
    }

    @Override
    public void writeArray(Object[] a) {
        if (a == null) {
            this.writeNull();
        } else {
            this._arrayType.write(a);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeObject(Object o) {
        AMQPType type = this._typeRegistry.get(o == null ? Void.class : o.getClass());
        if (type == null) {
            if (o.getClass().isArray()) {
                Class<?> componentType = o.getClass().getComponentType();
                if (componentType.isPrimitive()) {
                    if (componentType == Boolean.TYPE) {
                        this.writeArray((boolean[])o);
                        return;
                    } else if (componentType == Byte.TYPE) {
                        this.writeArray((byte[])o);
                        return;
                    } else if (componentType == Short.TYPE) {
                        this.writeArray((short[])o);
                        return;
                    } else if (componentType == Integer.TYPE) {
                        this.writeArray((int[])o);
                        return;
                    } else if (componentType == Long.TYPE) {
                        this.writeArray((long[])o);
                        return;
                    } else if (componentType == Float.TYPE) {
                        this.writeArray((float[])o);
                        return;
                    } else if (componentType == Double.TYPE) {
                        this.writeArray((double[])o);
                        return;
                    } else {
                        if (componentType != Character.TYPE) throw new IllegalArgumentException("Cannot write arrays of type " + componentType.getName());
                        this.writeArray((char[])o);
                    }
                    return;
                } else {
                    this.writeArray((Object[])o);
                }
                return;
            } else if (o instanceof List) {
                this.writeList((List)o);
                return;
            } else if (o instanceof Map) {
                this.writeMap((Map)o);
                return;
            } else {
                if (!(o instanceof DescribedType)) throw new IllegalArgumentException("Do not know how to write Objects of class " + o.getClass().getName());
                this.writeDescribedType((DescribedType)o);
            }
            return;
        } else {
            type.write(o);
        }
    }

    public void writeRaw(byte b) {
        this._buffer.put(b);
    }

    void writeRaw(short s) {
        this._buffer.putShort(s);
    }

    void writeRaw(int i) {
        this._buffer.putInt(i);
    }

    void writeRaw(long l) {
        this._buffer.putLong(l);
    }

    void writeRaw(float f) {
        this._buffer.putFloat(f);
    }

    void writeRaw(double d) {
        this._buffer.putDouble(d);
    }

    void writeRaw(byte[] src, int offset, int length) {
        this._buffer.put(src, offset, length);
    }

    void writeRaw(String string) {
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char low;
            int c = string.charAt(i);
            if ((c & 0xFF80) == 0) {
                this._buffer.put((byte)c);
                continue;
            }
            if ((c & 0xF800) == 0) {
                this._buffer.put((byte)(0xC0 | c >> 6 & 0x1F));
                this._buffer.put((byte)(0x80 | c & 0x3F));
                continue;
            }
            if ((c & 0xD800) != 55296 || c > 56319) {
                this._buffer.put((byte)(0xE0 | c >> 12 & 0xF));
                this._buffer.put((byte)(0x80 | c >> 6 & 0x3F));
                this._buffer.put((byte)(0x80 | c & 0x3F));
                continue;
            }
            if (++i == length || ((low = string.charAt(i)) & 0xDC00) != 56320) {
                throw new IllegalArgumentException("String contains invalid Unicode code points");
            }
            c = 65536 + ((c & 0x3FF) << 10) + (low & 0x3FF);
            this._buffer.put((byte)(0xF0 | c >> 18 & 7));
            this._buffer.put((byte)(0x80 | c >> 12 & 0x3F));
            this._buffer.put((byte)(0x80 | c >> 6 & 0x3F));
            this._buffer.put((byte)(0x80 | c & 0x3F));
        }
    }
}

