/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.plugin.java;

import java.util.Arrays;
import java.util.Set;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.virtual.VirtualDestination;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.network.DiscoveryNetworkConnector;
import org.apache.activemq.plugin.AbstractRuntimeConfigurationBroker;
import org.apache.activemq.plugin.UpdateVirtualDestinationsTask;
import org.apache.activemq.plugin.util.PolicyEntryUtil;
import org.apache.activemq.security.AuthorizationBroker;
import org.apache.activemq.security.AuthorizationMap;
import org.apache.activemq.security.SimpleAuthenticationBroker;
import org.apache.activemq.security.SimpleAuthenticationPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaRuntimeConfigurationBroker
extends AbstractRuntimeConfigurationBroker {
    public static final Logger LOG = LoggerFactory.getLogger(JavaRuntimeConfigurationBroker.class);

    public JavaRuntimeConfigurationBroker(Broker next) {
        super(next);
    }

    public void setVirtualDestinations(final VirtualDestination[] virtualDestinations) {
        this.addDestinationWork.add(new UpdateVirtualDestinationsTask(this){

            @Override
            protected VirtualDestination[] getVirtualDestinations() {
                return virtualDestinations;
            }
        });
    }

    public void setVirtualDestinations(VirtualDestination[] virtualDestinations, boolean applyImmediately) throws Exception {
        this.setVirtualDestinations(virtualDestinations);
        if (applyImmediately) {
            this.applyDestinationWork();
        }
    }

    public void setDestinations(ActiveMQDestination[] destinations) {
        for (ActiveMQDestination destination : destinations) {
            try {
                if (this.containsDestination(destination)) continue;
                this.addDestination(this.getBrokerService().getAdminConnectionContext(), destination, true);
                this.info("Added destination " + destination);
            }
            catch (Exception e) {
                this.info("Failed to add a new destination for: " + destination, e);
            }
        }
    }

    protected boolean containsDestination(ActiveMQDestination destination) throws Exception {
        return Arrays.asList(this.getBrokerService().getRegionBroker().getDestinations()).contains(destination);
    }

    public void addNewDestination(ActiveMQDestination destination) {
        try {
            this.addDestination(this.getBrokerService().getAdminConnectionContext(), destination, true);
            this.info("Added destination " + destination);
        }
        catch (Exception e) {
            this.info("Failed to add a new destination for: " + destination, e);
        }
    }

    public void addNetworkConnector(DiscoveryNetworkConnector nc) {
        try {
            if (!this.getBrokerService().getNetworkConnectors().contains(nc)) {
                this.getBrokerService().addNetworkConnector(nc);
                this.getBrokerService().startNetworkConnector(nc, null);
                this.info("started new network connector: " + nc);
            } else {
                this.info("skipping network connector add, already exists: " + nc);
            }
        }
        catch (Exception e) {
            this.info("Failed to add new networkConnector " + nc, e);
        }
    }

    public void updateNetworkConnector(DiscoveryNetworkConnector nc) {
        this.removeNetworkConnector(nc);
        this.addNetworkConnector(nc);
    }

    public void removeNetworkConnector(DiscoveryNetworkConnector existingCandidate) {
        if (this.getBrokerService().removeNetworkConnector(existingCandidate)) {
            try {
                existingCandidate.stop();
                this.info("stopped and removed networkConnector: " + existingCandidate);
            }
            catch (Exception e) {
                this.info("Failed to stop removed network connector: " + existingCandidate);
            }
        }
    }

    public void addNewPolicyEntry(PolicyEntry addition) {
        PolicyMap existingMap = this.getBrokerService().getDestinationPolicy();
        existingMap.put(addition.getDestination(), addition);
        PolicyEntryUtil.applyRetrospectively(this, addition, null);
        this.info("added policy for: " + addition.getDestination());
    }

    public void modifyPolicyEntry(PolicyEntry existing) {
        this.modifyPolicyEntry(existing, false);
    }

    public void modifyPolicyEntry(PolicyEntry existing, boolean createOrReplace) {
        this.modifyPolicyEntry(existing, createOrReplace, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyPolicyEntry(PolicyEntry existing, boolean createOrReplace, Set<String> includedProperties) {
        PolicyMap existingMap = this.getBrokerService().getDestinationPolicy();
        PolicyEntry existingEntry = PolicyEntryUtil.findEntryByDestination(this, existing);
        if (createOrReplace) {
            if (existingEntry == null) {
                existingMap.put(existing.getDestination(), existing);
                existingEntry = existing;
            } else if (!existing.equals(existingEntry)) {
                PolicyMap policyMap = existingMap;
                synchronized (policyMap) {
                    existingMap.remove(existingEntry.getDestination(), existingEntry);
                    existingMap.put(existing.getDestination(), existing);
                }
                existingEntry = existing;
            }
        }
        if (existingEntry == null || !existingEntry.equals(existing)) {
            throw new IllegalArgumentException("The policy can not be updated because it either does not exist or the PolicyEntry reference does not match an existing PolicyEntry in the PolicyMap.  To replace an entry (versus modifying) or add, set createOrReplace to true. " + existing + ", destination:" + existing.getDestination());
        }
        PolicyEntryUtil.applyRetrospectively(this, existingEntry, includedProperties);
        this.info("updated policy for: " + existingEntry.getDestination());
    }

    public void updateSimpleAuthenticationPlugin(final SimpleAuthenticationPlugin updatedPlugin) {
        try {
            final SimpleAuthenticationBroker authenticationBroker = (SimpleAuthenticationBroker)this.getBrokerService().getBroker().getAdaptor(SimpleAuthenticationBroker.class);
            this.addConnectionWork.add(new Runnable(){

                @Override
                public void run() {
                    authenticationBroker.setUserGroups(updatedPlugin.getUserGroups());
                    authenticationBroker.setUserPasswords(updatedPlugin.getUserPasswords());
                    authenticationBroker.setAnonymousAccessAllowed(updatedPlugin.isAnonymousAccessAllowed());
                    authenticationBroker.setAnonymousUser(updatedPlugin.getAnonymousUser());
                    authenticationBroker.setAnonymousGroup(updatedPlugin.getAnonymousGroup());
                }
            });
        }
        catch (Exception e) {
            this.info("failed to apply SimpleAuthenticationPlugin modifications to SimpleAuthenticationBroker", e);
        }
    }

    public void updateAuthorizationMap(AuthorizationMap authorizationMap) {
        try {
            AuthorizationBroker authorizationBroker = (AuthorizationBroker)this.getBrokerService().getBroker().getAdaptor(AuthorizationBroker.class);
            authorizationBroker.setAuthorizationMap(authorizationMap);
        }
        catch (Exception e) {
            this.info("failed to apply modified AuthorizationMap to AuthorizationBroker", e);
        }
    }
}

