/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel.component.broker;

import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.inteceptor.MessageInterceptor;
import org.apache.activemq.camel.component.broker.BrokerEndpoint;
import org.apache.activemq.camel.component.broker.BrokerJmsMessage;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.jms.JmsBinding;
import org.apache.camel.impl.DefaultConsumer;

public class BrokerConsumer
extends DefaultConsumer
implements MessageInterceptor {
    private final JmsBinding jmsBinding = new JmsBinding();

    public BrokerConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    protected void doStart() throws Exception {
        super.doStart();
        ((BrokerEndpoint)this.getEndpoint()).addMessageInterceptor(this);
    }

    protected void doStop() throws Exception {
        ((BrokerEndpoint)this.getEndpoint()).removeMessageInterceptor(this);
        super.doStop();
    }

    @Override
    public void intercept(ProducerBrokerExchange producerExchange, org.apache.activemq.command.Message message) {
        Exchange exchange = this.getEndpoint().createExchange(ExchangePattern.InOnly);
        exchange.setIn((Message)new BrokerJmsMessage((javax.jms.Message)message, this.jmsBinding));
        exchange.setProperty("CamelBinding", (Object)this.jmsBinding);
        exchange.setProperty("producerBrokerExchange", (Object)producerExchange);
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        if (exchange.getException() != null) {
            this.getExceptionHandler().handleException("Error processing intercepted message: " + message, exchange, (Throwable)exchange.getException());
        }
    }
}

