/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipOutputStream;
import org.apache.aries.util.internal.MessageUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class FragmentBuilder {
    private List<String> importPackages = new ArrayList<String>();
    private List<String> exportPackages = new ArrayList<String>();
    private Bundle hostBundle;
    private String nameExtension;
    private String bundleNameExtension;
    private String fragmentName;
    private Map<String, byte[]> files = new HashMap<String, byte[]>();

    public FragmentBuilder(Bundle host) {
        this(host, ".fragment", "Fragment");
    }

    public FragmentBuilder(Bundle host, String symbolicNameSuffix, String bundleNameSuffix) {
        this.hostBundle = host;
        this.nameExtension = symbolicNameSuffix;
        this.bundleNameExtension = bundleNameSuffix;
        if (!this.nameExtension.startsWith(".")) {
            this.nameExtension = "." + this.nameExtension;
        }
    }

    public void setName(String name) {
        this.fragmentName = name;
    }

    public void addImports(String ... imports) {
        this.importPackages.addAll(Arrays.asList(imports));
    }

    public void addExports(String ... imports) {
        this.exportPackages.addAll(Arrays.asList(imports));
    }

    public void addImportsFromExports(Bundle exportBundle) {
        String exportString = (String)exportBundle.getHeaders().get("Export-Package");
        if (exportString != null) {
            String exportVersion = exportBundle.getVersion().toString();
            String bundleConstraint = "bundle-symbolic-name=\"" + exportBundle.getSymbolicName() + "\"";
            String bundleVersionConstraint = "bundle-version=\"[" + exportVersion + "," + exportVersion + "]\"";
            List<String> exports = FragmentBuilder.parseDelimitedString(exportString, ",", true);
            for (String export : exports) {
                this.importPackages.add(this.convertExportToImport(export, bundleConstraint, bundleVersionConstraint));
            }
        }
    }

    private String convertExportToImport(String exportStatement, String bundleConstraint, String bundleVersionConstraint) {
        StringBuffer result = new StringBuffer();
        for (String fragment : exportStatement.split("\\s*;\\s*")) {
            int pos = fragment.indexOf(61);
            if (pos > 0 && fragment.charAt(pos - 1) == ':') continue;
            result.append(fragment);
            result.append(';');
        }
        result.append(bundleConstraint);
        result.append(';');
        result.append(bundleVersionConstraint);
        return result.toString();
    }

    public void addFile(String path, byte[] content) {
        this.files.put(path, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle install(BundleContext ctx) throws IOException, BundleException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream jos = null;
        try {
            jos = new JarOutputStream((OutputStream)baos, this.makeManifest());
            this.addFileContent((JarOutputStream)jos);
        }
        finally {
            if (jos != null) {
                jos.close();
            }
            baos.close();
        }
        byte[] inMemoryJar = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(inMemoryJar);
        return ctx.installBundle(this.getFragmentSymbolicName(), (InputStream)bais);
    }

    private void addFileContent(JarOutputStream jos) throws IOException {
        for (Map.Entry<String, byte[]> entry : this.files.entrySet()) {
            jos.putNextEntry(new JarEntry(entry.getKey()));
            jos.write(entry.getValue());
        }
    }

    public String getFragmentSymbolicName() {
        return this.hostBundle.getSymbolicName() + this.nameExtension;
    }

    public String getFragmentBundleName() {
        if (this.fragmentName != null) {
            return this.fragmentName;
        }
        String bundleName = (String)this.hostBundle.getHeaders().get("Bundle-Name");
        if (bundleName != null && this.bundleNameExtension != null) {
            return bundleName.trim() + " " + this.bundleNameExtension.trim();
        }
        return null;
    }

    private Manifest makeManifest() {
        String commonVersion = this.hostBundle.getVersion().toString();
        String fragmentHost = this.hostBundle.getSymbolicName() + ";" + "bundle-version" + "=\"" + commonVersion + "\"";
        Manifest m = new Manifest();
        Attributes manifestAttributes = m.getMainAttributes();
        manifestAttributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        manifestAttributes.putValue("Bundle-ManifestVersion", "2");
        manifestAttributes.putValue("Bundle-SymbolicName", this.getFragmentSymbolicName());
        String bundleName = this.getFragmentBundleName();
        if (bundleName != null) {
            manifestAttributes.putValue("Bundle-Name", bundleName);
        }
        manifestAttributes.putValue("Bundle-Version", commonVersion);
        manifestAttributes.putValue("Bundle-Vendor", "Apache");
        manifestAttributes.putValue("Fragment-Host", fragmentHost);
        this.addImportsAndExports(manifestAttributes);
        return m;
    }

    private void addImportsAndExports(Attributes attrs) {
        if (!this.importPackages.isEmpty()) {
            attrs.putValue("Import-Package", this.joinStrings(this.importPackages, ','));
        }
        if (!this.exportPackages.isEmpty()) {
            attrs.putValue("Export-Package", this.joinStrings(this.exportPackages, ','));
        }
    }

    private String joinStrings(List<String> strs, char separator) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String str : strs) {
            if (first) {
                first = false;
            } else {
                result.append(separator);
            }
            result.append(str);
        }
        return result.toString();
    }

    private static List<String> parseDelimitedString(String value, String delim, boolean includeQuotes) {
        if (value == null) {
            value = "";
        }
        ArrayList<String> list = new ArrayList<String>();
        int CHAR = 1;
        int DELIMITER = 2;
        int STARTQUOTE = 4;
        int ENDQUOTE = 8;
        StringBuffer sb = new StringBuffer();
        int expecting = CHAR | DELIMITER | STARTQUOTE;
        for (int i = 0; i < value.length(); ++i) {
            boolean isQuote;
            char c = value.charAt(i);
            boolean isDelimiter = delim.indexOf(c) >= 0;
            boolean bl = isQuote = c == '\"';
            if (isDelimiter && (expecting & DELIMITER) > 0) {
                list.add(sb.toString().trim());
                sb.delete(0, sb.length());
                expecting = CHAR | DELIMITER | STARTQUOTE;
                continue;
            }
            if (isQuote && (expecting & STARTQUOTE) > 0) {
                if (includeQuotes) {
                    sb.append(c);
                }
                expecting = CHAR | ENDQUOTE;
                continue;
            }
            if (isQuote && (expecting & ENDQUOTE) > 0) {
                if (includeQuotes) {
                    sb.append(c);
                }
                expecting = CHAR | STARTQUOTE | DELIMITER;
                continue;
            }
            if ((expecting & CHAR) > 0) {
                sb.append(c);
                continue;
            }
            throw new IllegalArgumentException(MessageUtil.getMessage("UTIL0012E", value));
        }
        if (sb.length() > 0) {
            list.add(sb.toString().trim());
        }
        return list;
    }
}

