/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.annotations;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import org.eclipse.jetty.websocket.jsr356.JsrSession;
import org.eclipse.jetty.websocket.jsr356.annotations.OnMessageCallable;
import org.eclipse.jetty.websocket.jsr356.annotations.Param;

public class OnMessageBinaryCallable
extends OnMessageCallable {
    private Decoder.Binary<?> binaryDecoder;

    public OnMessageBinaryCallable(Class<?> pojo, Method method) {
        super(pojo, method);
    }

    public OnMessageBinaryCallable(OnMessageCallable copy) {
        super(copy);
    }

    public Object call(Object endpoint, ByteBuffer buf, boolean partialFlag) throws DecodeException {
        if (this.binaryDecoder.willDecode(buf.slice())) {
            this.args[this.idxMessageObject] = this.binaryDecoder.decode(buf);
            if (this.idxPartialMessageFlag >= 0) {
                this.args[this.idxPartialMessageFlag] = partialFlag;
            }
            return super.call(endpoint, this.args);
        }
        return null;
    }

    @Override
    public void init(JsrSession session) {
        this.idxMessageObject = this.findIndexForRole(Param.Role.MESSAGE_BINARY);
        this.assertRoleRequired(this.idxMessageObject, "Binary Message Object");
        super.init(session);
        this.assertDecoderRequired();
        this.binaryDecoder = (Decoder.Binary)this.getDecoder();
    }
}

