/*
 * Decompiled with CFR 0.152.
 */
package org.dhcp4java;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class Util {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private Util() {
    }

    private static void _appendHex(StringBuilder stringBuilder, byte by) {
        int n = by & 0xFF;
        stringBuilder.append(HEX_CHARS[(n & 0xF0) >> 4]).append(HEX_CHARS[n & 0xF]);
    }

    static void appendHex(StringBuilder stringBuilder, byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return;
        }
        int n3 = n;
        int n4 = n2;
        if (n3 < 0) {
            n4 += n3;
            n3 = 0;
        }
        if (n4 <= 0 || n3 >= byArray.length) {
            return;
        }
        if (n3 + n4 > byArray.length) {
            n4 = byArray.length - n3;
        }
        for (int i = n3; i < n3 + n4; ++i) {
            Util._appendHex(stringBuilder, byArray[i]);
        }
    }

    static void appendHex(StringBuilder stringBuilder, byte[] byArray) {
        Util.appendHex(stringBuilder, byArray, 0, byArray.length);
    }

    static String bytes2Hex(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        Util.appendHex(stringBuilder, byArray);
        return stringBuilder.toString();
    }

    static byte[] hex2Bytes(String string) {
        if ((string.length() & 1) != 0) {
            throw new IllegalArgumentException("String length must be even: " + string.length());
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = i << 1;
            byArray[i] = (byte)Integer.parseInt(string.substring(n, n + 2), 16);
        }
        return byArray;
    }

    static void appendHex(StringBuilder stringBuilder, int n) {
        Util._appendHex(stringBuilder, (byte)((n & 0xFF000000) >>> 24));
        Util._appendHex(stringBuilder, (byte)((n & 0xFF0000) >>> 16));
        Util._appendHex(stringBuilder, (byte)((n & 0xFF00) >>> 8));
        Util._appendHex(stringBuilder, (byte)(n & 0xFF));
    }

    public static byte[] stringToBytes(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    static String bytesToString(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        return Util.bytesToString(byArray, 0, byArray.length);
    }

    static String bytesToString(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return "";
        }
        int n3 = n;
        int n4 = n2;
        if (n3 < 0) {
            n4 += n3;
            n3 = 0;
        }
        if (n4 <= 0) {
            return "";
        }
        if (n3 >= byArray.length) {
            return "";
        }
        if (n3 + n4 > byArray.length) {
            n4 = byArray.length - n3;
        }
        for (int i = n3; i < n3 + n4; ++i) {
            if (byArray[i] != 0) continue;
            n4 = i - n3;
            break;
        }
        char[] cArray = new char[n4];
        for (int i = n3; i < n3 + n4; ++i) {
            cArray[i - n3] = (char)byArray[i];
        }
        return new String(cArray);
    }

    public static final InetAddress int2InetAddress(int n) {
        byte[] byArray = new byte[]{(byte)((n & 0xFF000000) >>> 24), (byte)((n & 0xFF0000) >>> 16), (byte)((n & 0xFF00) >>> 8), (byte)(n & 0xFF)};
        try {
            return InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public static final InetAddress long2InetAddress(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            // empty if block
        }
        return Util.int2InetAddress((int)l);
    }

    public static final int inetAddress2Int(InetAddress inetAddress) {
        if (!(inetAddress instanceof Inet4Address)) {
            throw new IllegalArgumentException("Only IPv4 supported");
        }
        byte[] byArray = inetAddress.getAddress();
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    public static final long inetAddress2Long(InetAddress inetAddress) {
        return (long)Util.inetAddress2Int(inetAddress) & 0xFFFFFFFFL;
    }

    public static void appendHostAddress(StringBuilder stringBuilder, InetAddress inetAddress) {
        if (inetAddress == null) {
            throw new IllegalArgumentException("addr must not be null");
        }
        if (!(inetAddress instanceof Inet4Address)) {
            throw new IllegalArgumentException("addr must be an instance of Inet4Address");
        }
        byte[] byArray = inetAddress.getAddress();
        stringBuilder.append(byArray[0] & 0xFF).append('.').append(byArray[1] & 0xFF).append('.').append(byArray[2] & 0xFF).append('.').append(byArray[3] & 0xFF);
    }

    public static String getHostAddress(InetAddress inetAddress) {
        StringBuilder stringBuilder = new StringBuilder(15);
        Util.appendHostAddress(stringBuilder, inetAddress);
        return stringBuilder.toString();
    }
}

