/*
 * Decompiled with CFR 0.152.
 */
package org.dhcp4java;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.dhcp4java.DHCPBadPacketException;
import org.dhcp4java.DHCPConstants;
import org.dhcp4java.DHCPOption;
import org.dhcp4java.DHCPPacket;

public final class DHCPResponseFactory {
    private DHCPResponseFactory() {
    }

    public static final DHCPPacket makeDHCPOffer(DHCPPacket dHCPPacket, InetAddress inetAddress, int n, InetAddress inetAddress2, String string, DHCPOption[] dHCPOptionArray) {
        if (dHCPPacket == null) {
            throw new NullPointerException("request is null");
        }
        if (!dHCPPacket.isDhcp()) {
            throw new DHCPBadPacketException("request is BOOTP");
        }
        Byte by = dHCPPacket.getDHCPMessageType();
        if (by == null) {
            throw new DHCPBadPacketException("request has no message type");
        }
        if (by != 1) {
            throw new DHCPBadPacketException("request is not DHCPDISCOVER");
        }
        if (inetAddress == null) {
            throw new IllegalArgumentException("offeredAddress must not be null");
        }
        if (!(inetAddress instanceof Inet4Address)) {
            throw new IllegalArgumentException("offeredAddress must be IPv4");
        }
        DHCPPacket dHCPPacket2 = new DHCPPacket();
        dHCPPacket2.setOp((byte)2);
        dHCPPacket2.setHtype(dHCPPacket.getHtype());
        dHCPPacket2.setHlen(dHCPPacket.getHlen());
        dHCPPacket2.setXid(dHCPPacket.getXid());
        dHCPPacket2.setFlags(dHCPPacket.getFlags());
        dHCPPacket2.setYiaddr(inetAddress);
        dHCPPacket2.setGiaddrRaw(dHCPPacket.getGiaddrRaw());
        dHCPPacket2.setChaddr(dHCPPacket.getChaddr());
        dHCPPacket2.setDHCPMessageType((byte)2);
        dHCPPacket2.setOptionAsInt((byte)51, n);
        dHCPPacket2.setOptionAsInetAddress((byte)54, inetAddress2);
        dHCPPacket2.setOptionAsString((byte)56, string);
        if (dHCPOptionArray != null) {
            for (DHCPOption dHCPOption : dHCPOptionArray) {
                dHCPPacket2.setOption(dHCPOption.applyOption(dHCPPacket));
            }
        }
        dHCPPacket2.setAddrPort(DHCPResponseFactory.getDefaultSocketAddress(dHCPPacket, (byte)2));
        return dHCPPacket2;
    }

    public static final DHCPPacket makeDHCPAck(DHCPPacket dHCPPacket, InetAddress inetAddress, int n, InetAddress inetAddress2, String string, DHCPOption[] dHCPOptionArray) {
        if (dHCPPacket == null) {
            throw new NullPointerException("request is null");
        }
        if (!dHCPPacket.isDhcp()) {
            throw new DHCPBadPacketException("request is BOOTP");
        }
        Byte by = dHCPPacket.getDHCPMessageType();
        if (by == null) {
            throw new DHCPBadPacketException("request has no message type");
        }
        if (by != 3 && by != 8) {
            throw new DHCPBadPacketException("request is not DHCPREQUEST/DHCPINFORM");
        }
        if (inetAddress == null) {
            throw new IllegalArgumentException("offeredAddress must not be null");
        }
        if (!(inetAddress instanceof Inet4Address)) {
            throw new IllegalArgumentException("offeredAddress must be IPv4");
        }
        DHCPPacket dHCPPacket2 = new DHCPPacket();
        dHCPPacket2.setOp((byte)2);
        dHCPPacket2.setHtype(dHCPPacket.getHtype());
        dHCPPacket2.setHlen(dHCPPacket.getHlen());
        dHCPPacket2.setXid(dHCPPacket.getXid());
        dHCPPacket2.setFlags(dHCPPacket.getFlags());
        dHCPPacket2.setCiaddrRaw(dHCPPacket.getCiaddrRaw());
        if (by != 8) {
            dHCPPacket2.setYiaddr(inetAddress);
        }
        dHCPPacket2.setGiaddrRaw(dHCPPacket.getGiaddrRaw());
        dHCPPacket2.setChaddr(dHCPPacket.getChaddr());
        dHCPPacket2.setDHCPMessageType((byte)5);
        if (by == 3) {
            dHCPPacket2.setOptionAsInt((byte)51, n);
        }
        dHCPPacket2.setOptionAsInetAddress((byte)54, inetAddress2);
        dHCPPacket2.setOptionAsString((byte)56, string);
        if (dHCPOptionArray != null) {
            for (DHCPOption dHCPOption : dHCPOptionArray) {
                dHCPPacket2.setOption(dHCPOption.applyOption(dHCPPacket));
            }
        }
        dHCPPacket2.setAddrPort(DHCPResponseFactory.getDefaultSocketAddress(dHCPPacket, (byte)5));
        return dHCPPacket2;
    }

    public static final DHCPPacket makeDHCPNak(DHCPPacket dHCPPacket, InetAddress inetAddress, String string) {
        if (dHCPPacket == null) {
            throw new NullPointerException("request is null");
        }
        if (!dHCPPacket.isDhcp()) {
            throw new DHCPBadPacketException("request is BOOTP");
        }
        Byte by = dHCPPacket.getDHCPMessageType();
        if (by == null) {
            throw new DHCPBadPacketException("request has no message type");
        }
        if (by != 3) {
            throw new DHCPBadPacketException("request is not DHCPREQUEST");
        }
        DHCPPacket dHCPPacket2 = new DHCPPacket();
        dHCPPacket2.setOp((byte)2);
        dHCPPacket2.setHtype(dHCPPacket.getHtype());
        dHCPPacket2.setHlen(dHCPPacket.getHlen());
        dHCPPacket2.setXid(dHCPPacket.getXid());
        dHCPPacket2.setFlags(dHCPPacket.getFlags());
        dHCPPacket2.setGiaddrRaw(dHCPPacket.getGiaddrRaw());
        dHCPPacket2.setChaddr(dHCPPacket.getChaddr());
        dHCPPacket2.setDHCPMessageType((byte)6);
        dHCPPacket2.setOptionAsInetAddress((byte)54, inetAddress);
        dHCPPacket2.setOptionAsString((byte)56, string);
        dHCPPacket2.setAddrPort(DHCPResponseFactory.getDefaultSocketAddress(dHCPPacket, (byte)6));
        return dHCPPacket2;
    }

    public static InetSocketAddress getDefaultSocketAddress(DHCPPacket dHCPPacket, byte by) {
        InetSocketAddress inetSocketAddress;
        if (dHCPPacket == null) {
            throw new IllegalArgumentException("request is null");
        }
        InetAddress inetAddress = dHCPPacket.getGiaddr();
        InetAddress inetAddress2 = dHCPPacket.getCiaddr();
        switch (by) {
            case 2: 
            case 5: {
                if (DHCPConstants.INADDR_ANY.equals(inetAddress)) {
                    if (DHCPConstants.INADDR_ANY.equals(inetAddress2)) {
                        inetSocketAddress = new InetSocketAddress(DHCPConstants.INADDR_BROADCAST, 68);
                        break;
                    }
                    inetSocketAddress = new InetSocketAddress(inetAddress2, 68);
                    break;
                }
                inetSocketAddress = new InetSocketAddress(inetAddress, 67);
                break;
            }
            case 6: {
                if (DHCPConstants.INADDR_ANY.equals(inetAddress)) {
                    inetSocketAddress = new InetSocketAddress(DHCPConstants.INADDR_BROADCAST, 68);
                    break;
                }
                inetSocketAddress = new InetSocketAddress(inetAddress, 67);
                break;
            }
            default: {
                throw new IllegalArgumentException("responseType not valid");
            }
        }
        return inetSocketAddress;
    }
}

