/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.icmp;

import org.opennms.protocols.icmp.ICMPHeader;
import org.opennms.protocols.ip.OC16ChecksumProducer;

public final class AddressMaskReply
extends ICMPHeader {
    private int m_mask;

    public AddressMaskReply() {
        super((byte)18, (byte)0);
        this.m_mask = 0;
    }

    public AddressMaskReply(byte[] buf, int offset) {
        this.loadFromBuffer(buf, offset);
    }

    public final void computeChecksum() {
        OC16ChecksumProducer summer = new OC16ChecksumProducer();
        super.computeChecksum(summer);
        summer.add(this.m_mask);
        this.setChecksum(summer.getChecksum());
    }

    public final int storeToBuffer(byte[] buf, int offset) {
        if (buf.length < offset + 12) {
            throw new IndexOutOfBoundsException("Array index overflow in buffer build");
        }
        this.computeChecksum();
        offset = super.storeToBuffer(buf, offset);
        buf[offset++] = (byte)(this.m_mask >> 24 & 0xFF);
        buf[offset++] = (byte)(this.m_mask >> 16 & 0xFF);
        buf[offset++] = (byte)(this.m_mask >> 8 & 0xFF);
        buf[offset++] = (byte)(this.m_mask & 0xFF);
        return offset;
    }

    public final int loadFromBuffer(byte[] buf, int offset) {
        if (buf.length < offset + 12) {
            throw new IndexOutOfBoundsException("Insufficient data to load ICMP header");
        }
        offset = super.loadFromBuffer(buf, offset);
        if (this.getType() != 18) {
            throw new IllegalArgumentException("The buffer did not contain an Address Mask Reply");
        }
        this.m_mask = AddressMaskReply.byteToInt(buf[offset++]) << 24 | AddressMaskReply.byteToInt(buf[offset++]) << 16 | AddressMaskReply.byteToInt(buf[offset++]) << 8 | AddressMaskReply.byteToInt(buf[offset++]);
        return offset;
    }

    public final int getAddressMask() {
        return this.m_mask;
    }

    public final void setAddressMask(int mask) {
        this.m_mask = mask;
    }

    public final byte[] toBytes() {
        byte[] buf = new byte[12];
        this.storeToBuffer(buf, 0);
        return buf;
    }
}

