/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.OutputStream;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

public class Null
extends AbstractVariable {
    private static final long serialVersionUID = 6907924131098190092L;
    private int syntax = 5;
    public static final Null noSuchObject = new Null(128);
    public static final Null noSuchInstance = new Null(129);
    public static final Null endOfMibView = new Null(130);
    public static final Null instance = new Null(5);

    public Null() {
    }

    public Null(int exceptionSyntax) {
        this.setSyntax(exceptionSyntax);
    }

    @Override
    public void decodeBER(BERInputStream inputStream) throws IOException {
        BER.MutableByte type = new BER.MutableByte();
        BER.decodeNull(inputStream, type);
        this.syntax = type.getValue() & 0xFF;
    }

    @Override
    public int getSyntax() {
        return this.syntax;
    }

    @Override
    public int hashCode() {
        return this.getSyntax();
    }

    @Override
    public int getBERLength() {
        return 2;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof Null && ((Null)o).getSyntax() == this.getSyntax();
    }

    @Override
    public int compareTo(Variable o) {
        return this.getSyntax() - o.getSyntax();
    }

    @Override
    public String toString() {
        switch (this.getSyntax()) {
            case 128: {
                return "noSuchObject";
            }
            case 129: {
                return "noSuchInstance";
            }
            case 130: {
                return "endOfMibView";
            }
        }
        return "Null";
    }

    @Override
    public void encodeBER(OutputStream outputStream) throws IOException {
        BER.encodeHeader(outputStream, (byte)this.getSyntax(), 0);
    }

    public void setSyntax(int syntax) {
        if (syntax != 5 && !Null.isExceptionSyntax(syntax)) {
            throw new IllegalArgumentException("Syntax " + syntax + " is incompatible with Null type");
        }
        this.syntax = syntax;
    }

    @Override
    public Object clone() {
        return new Null(this.syntax);
    }

    public static boolean isExceptionSyntax(int syntax) {
        switch (syntax) {
            case 128: 
            case 129: 
            case 130: {
                return true;
            }
        }
        return false;
    }

    @Override
    public final int toInt() {
        return this.getSyntax();
    }

    @Override
    public final long toLong() {
        return this.getSyntax();
    }

    @Override
    public OID toSubIndex(boolean impliedLength) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fromSubIndex(OID subIndex, boolean impliedLength) {
        throw new UnsupportedOperationException();
    }
}

