/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.pool;

import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.Control;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import javax.naming.ldap.LdapContext;
import org.apache.commons.lang.Validate;
import org.apache.commons.pool.KeyedObjectPool;
import org.springframework.ldap.pool.DelegatingDirContext;
import org.springframework.ldap.pool.DirContextType;

public class DelegatingLdapContext
extends DelegatingDirContext
implements LdapContext {
    private LdapContext delegateLdapContext;

    public DelegatingLdapContext(KeyedObjectPool keyedObjectPool, LdapContext delegateLdapContext, DirContextType dirContextType) {
        super(keyedObjectPool, delegateLdapContext, dirContextType);
        Validate.notNull((Object)delegateLdapContext, (String)"delegateLdapContext may not be null");
        this.delegateLdapContext = delegateLdapContext;
    }

    public LdapContext getDelegateLdapContext() {
        return this.delegateLdapContext;
    }

    public DirContext getDelegateDirContext() {
        return this.getDelegateLdapContext();
    }

    public LdapContext getInnermostDelegateLdapContext() {
        LdapContext delegateLdapContext = this.getDelegateLdapContext();
        if (delegateLdapContext instanceof DelegatingLdapContext) {
            return ((DelegatingLdapContext)delegateLdapContext).getInnermostDelegateLdapContext();
        }
        return delegateLdapContext;
    }

    protected void assertOpen() throws NamingException {
        if (this.delegateLdapContext == null) {
            throw new NamingException("LdapContext is closed.");
        }
        super.assertOpen();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LdapContext)) {
            return false;
        }
        LdapContext thisLdapContext = this.getInnermostDelegateLdapContext();
        LdapContext otherLdapContext = (LdapContext)obj;
        if (otherLdapContext instanceof DelegatingLdapContext) {
            otherLdapContext = ((DelegatingLdapContext)otherLdapContext).getInnermostDelegateLdapContext();
        }
        return thisLdapContext == otherLdapContext || thisLdapContext != null && thisLdapContext.equals(otherLdapContext);
    }

    public int hashCode() {
        LdapContext context = this.getInnermostDelegateLdapContext();
        return context != null ? context.hashCode() : 0;
    }

    public String toString() {
        LdapContext context = this.getInnermostDelegateLdapContext();
        return context != null ? context.toString() : "LdapContext is closed";
    }

    public ExtendedResponse extendedOperation(ExtendedRequest request) throws NamingException {
        this.assertOpen();
        return this.getDelegateLdapContext().extendedOperation(request);
    }

    public Control[] getConnectControls() throws NamingException {
        this.assertOpen();
        return this.getDelegateLdapContext().getConnectControls();
    }

    public Control[] getRequestControls() throws NamingException {
        this.assertOpen();
        return this.getDelegateLdapContext().getRequestControls();
    }

    public Control[] getResponseControls() throws NamingException {
        this.assertOpen();
        return this.getDelegateLdapContext().getResponseControls();
    }

    public LdapContext newInstance(Control[] requestControls) throws NamingException {
        throw new UnsupportedOperationException("Cannot call newInstance on a pooled context");
    }

    public void reconnect(Control[] connCtls) throws NamingException {
        throw new UnsupportedOperationException("Cannot call reconnect on a pooled context");
    }

    public void setRequestControls(Control[] requestControls) throws NamingException {
        throw new UnsupportedOperationException("Cannot call setRequestControls on a pooled context");
    }

    public void close() throws NamingException {
        if (this.delegateLdapContext == null) {
            return;
        }
        super.close();
        this.delegateLdapContext = null;
    }
}

