/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.jicmp.standalone;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.opennms.jicmp.ip.ICMPEchoPacket;
import org.opennms.jicmp.ip.ICMPPacket;
import org.opennms.jicmp.standalone.PingReply;

class V4PingReply
extends ICMPEchoPacket
implements PingReply {
    public static final long COOKIE = 5724186650822398753L;
    private long m_receivedTimeNanos;

    public V4PingReply(ICMPPacket icmpPacket, long receivedTimeNanos) {
        super(icmpPacket);
        this.m_receivedTimeNanos = receivedTimeNanos;
    }

    public boolean isValid() {
        ByteBuffer content = this.getContentBuffer();
        return content.limit() >= 16 && 5724186650822398753L == content.getLong(0);
    }

    public boolean isEchoReply() {
        return ICMPPacket.Type.EchoReply.equals((Object)this.getType());
    }

    @Override
    public long getSentTimeNanos() {
        return this.getContentBuffer().getLong(8);
    }

    @Override
    public long getReceivedTimeNanos() {
        return this.m_receivedTimeNanos;
    }

    @Override
    public double elapsedTime(TimeUnit unit) {
        double nanosPerUnit = TimeUnit.NANOSECONDS.convert(1L, unit);
        return (double)this.getElapsedTimeNanos() / nanosPerUnit;
    }

    @Override
    public long getElapsedTimeNanos() {
        return this.getReceivedTimeNanos() - this.getSentTimeNanos();
    }

    @Override
    public long getThreadId() {
        return this.getIdentifier();
    }
}

