/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.jicmp.standalone;

import java.util.concurrent.TimeUnit;

public class Metric {
    private int m_count = 0;
    private double m_sumOfSquaresOfDifferences = 0.0;
    private double m_average = 0.0;
    private long m_min = Long.MAX_VALUE;
    private long m_max = Long.MIN_VALUE;

    public int getCount() {
        return this.m_count;
    }

    public double getSumOfSquaresOfDifferences() {
        return this.m_sumOfSquaresOfDifferences;
    }

    public double getStandardDeviation() {
        return this.m_count == 0 ? 0.0 : Math.sqrt(this.getSumOfSquaresOfDifferences() / (double)this.getCount());
    }

    public double getAverage() {
        return this.m_average;
    }

    public long getMinimum() {
        return this.m_min;
    }

    public long getMaximum() {
        return this.m_max;
    }

    public void update(long sample) {
        ++this.m_count;
        double oldAvg = this.m_average;
        this.m_average += ((double)sample - oldAvg) / (double)this.m_count;
        this.m_sumOfSquaresOfDifferences += ((double)sample - this.getAverage()) * ((double)sample - oldAvg);
        this.m_min = Math.min(this.m_min, sample);
        this.m_max = Math.max(this.m_max, sample);
    }

    public String getSummary(TimeUnit unit) {
        double nanosPerUnit = TimeUnit.NANOSECONDS.convert(1L, unit);
        return String.format("cnt/min/avg/max/stddev = %d/%.3f/%.3f/%.3f/%.3f", this.getCount(), (double)this.getMinimum() / nanosPerUnit, this.getAverage() / nanosPerUnit, (double)this.getMaximum() / nanosPerUnit, this.getStandardDeviation() / nanosPerUnit);
    }
}

