/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.snmp;

import java.net.InetAddress;
import java.util.List;
import org.opennms.core.utils.ByteArrayComparator;
import org.opennms.core.utils.IPLike;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LocationUtils;
import org.opennms.netmgt.config.snmp.AbstractSnmpConfigVisitor;
import org.opennms.netmgt.config.snmp.Configuration;
import org.opennms.netmgt.config.snmp.Definition;
import org.opennms.netmgt.config.snmp.Range;
import org.opennms.netmgt.config.snmp.SnmpConfig;
import org.opennms.netmgt.config.snmp.SnmpConfigVisitor;
import org.opennms.netmgt.snmp.SnmpConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressSnmpConfigVisitor
extends AbstractSnmpConfigVisitor
implements SnmpConfigVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(AddressSnmpConfigVisitor.class);
    private static final ByteArrayComparator BYTE_ARRAY_COMPARATOR = new ByteArrayComparator();
    private final InetAddress m_address;
    private final String m_location;
    private SnmpConfig m_currentConfig;
    private Definition m_currentDefinition;
    private String m_currentLocation;
    private Definition m_matchedDefinitionAtDefaultLocation;
    private Definition m_matchedDefinitionAtGivenLocation;
    private Definition m_generatedDefinition = null;

    public AddressSnmpConfigVisitor(InetAddress addr) {
        this(addr, null);
    }

    public AddressSnmpConfigVisitor(InetAddress addr, String location) {
        this.m_address = addr;
        this.m_location = LocationUtils.getEffectiveLocationName((String)location);
    }

    @Override
    public void visitSnmpConfig(SnmpConfig config) {
        this.m_currentConfig = config;
    }

    @Override
    public void visitDefinition(Definition definition) {
        this.m_currentDefinition = definition;
        this.m_currentLocation = LocationUtils.getEffectiveLocationName((String)definition.getLocation());
    }

    private void handleMatch() {
        if (LocationUtils.isDefaultLocationName((String)this.m_currentLocation)) {
            this.m_matchedDefinitionAtDefaultLocation = this.m_currentDefinition;
        }
        if (this.m_location.equals(this.m_currentLocation)) {
            this.m_matchedDefinitionAtGivenLocation = this.m_currentDefinition;
        }
    }

    private Definition getBestMatch() {
        if (this.m_matchedDefinitionAtGivenLocation != null) {
            return this.m_matchedDefinitionAtGivenLocation;
        }
        return this.m_matchedDefinitionAtDefaultLocation;
    }

    private boolean shouldTryToMatch() {
        if (LocationUtils.isDefaultLocationName((String)this.m_currentLocation)) {
            return this.m_matchedDefinitionAtDefaultLocation == null;
        }
        if (this.m_location.equals(this.m_currentLocation)) {
            return this.m_matchedDefinitionAtGivenLocation == null;
        }
        return false;
    }

    @Override
    public void visitSpecifics(List<String> specifics) {
        if (!this.shouldTryToMatch()) {
            return;
        }
        for (String saddr : specifics) {
            try {
                InetAddress addr = InetAddressUtils.addr((String)saddr);
                if (addr == null || !addr.equals(this.m_address)) continue;
                this.handleMatch();
                return;
            }
            catch (IllegalArgumentException e) {
                LOG.info("Error while reading SNMP config <specific> tag: {}", (Object)saddr, (Object)e);
            }
        }
    }

    @Override
    public void visitRanges(List<Range> ranges) {
        if (!this.shouldTryToMatch()) {
            return;
        }
        for (Range range : ranges) {
            boolean inRange;
            byte[] end;
            byte[] addr = this.m_address.getAddress();
            byte[] begin = InetAddressUtils.toIpAddrBytes((String)range.getBegin());
            if (BYTE_ARRAY_COMPARATOR.compare(begin, end = InetAddressUtils.toIpAddrBytes((String)range.getEnd())) <= 0) {
                inRange = InetAddressUtils.isInetAddressInRange((byte[])addr, (byte[])begin, (byte[])end);
            } else {
                LOG.warn("{} has an 'end' that is earlier than its 'beginning'!", (Object)range);
                inRange = InetAddressUtils.isInetAddressInRange((byte[])addr, (byte[])end, (byte[])begin);
            }
            if (!inRange) continue;
            this.handleMatch();
            return;
        }
    }

    @Override
    public void visitIpMatches(List<String> ipMatches) {
        if (!this.shouldTryToMatch()) {
            return;
        }
        for (String ipMatch : ipMatches) {
            if (!IPLike.matches((InetAddress)this.m_address, (String)ipMatch)) continue;
            this.handleMatch();
            return;
        }
    }

    @Override
    public void visitDefinitionFinished() {
        this.m_currentDefinition = null;
    }

    @Override
    public void visitSnmpConfigFinished() {
        Definition ret = new Definition();
        Configuration sourceConfig = this.getBestMatch() != null ? this.getBestMatch() : this.m_currentConfig;
        if (sourceConfig.getProxyHost() != null) {
            ret.setProxyHost(sourceConfig.getProxyHost());
        } else {
            ret.setProxyHost(this.m_currentConfig.getProxyHost());
        }
        if (sourceConfig.hasMaxVarsPerPdu()) {
            ret.setMaxVarsPerPdu(sourceConfig.getMaxVarsPerPdu());
        } else if (this.m_currentConfig.hasMaxVarsPerPdu()) {
            ret.setMaxVarsPerPdu(this.m_currentConfig.getMaxVarsPerPdu());
        } else {
            ret.setMaxVarsPerPdu(10);
        }
        if (sourceConfig.hasMaxRepetitions()) {
            ret.setMaxRepetitions(sourceConfig.getMaxRepetitions());
        } else if (this.m_currentConfig.hasMaxRepetitions()) {
            ret.setMaxRepetitions(this.m_currentConfig.getMaxRepetitions());
        } else {
            ret.setMaxRepetitions(2);
        }
        if (sourceConfig.hasMaxRequestSize()) {
            ret.setMaxRequestSize(sourceConfig.getMaxRequestSize());
        } else if (this.m_currentConfig.hasMaxRequestSize()) {
            ret.setMaxRequestSize(this.m_currentConfig.getMaxRequestSize());
        } else {
            ret.setMaxRequestSize(65535);
        }
        if (sourceConfig.getSecurityName() != null) {
            ret.setSecurityName(sourceConfig.getSecurityName());
        } else if (this.m_currentConfig.getSecurityName() != null) {
            ret.setSecurityName(this.m_currentConfig.getSecurityName());
        } else {
            ret.setSecurityName("opennmsUser");
        }
        if (sourceConfig.getAuthPassphrase() != null) {
            ret.setAuthPassphrase(sourceConfig.getAuthPassphrase());
        } else if (this.m_currentConfig.getAuthPassphrase() != null) {
            ret.setAuthPassphrase(this.m_currentConfig.getAuthPassphrase());
        }
        if (sourceConfig.getAuthProtocol() != null) {
            ret.setAuthProtocol(sourceConfig.getAuthProtocol());
        } else if (this.m_currentConfig.getAuthProtocol() != null) {
            ret.setAuthProtocol(this.m_currentConfig.getAuthProtocol());
        } else {
            ret.setAuthProtocol("MD5");
        }
        if (sourceConfig.getEngineId() != null) {
            ret.setEngineId(sourceConfig.getEngineId());
        } else if (this.m_currentConfig.getEngineId() != null) {
            ret.setEngineId(this.m_currentConfig.getEngineId());
        } else {
            ret.setEngineId(SnmpConfiguration.DEFAULT_ENGINE_ID);
        }
        if (sourceConfig.getContextEngineId() != null) {
            ret.setContextEngineId(sourceConfig.getContextEngineId());
        } else if (this.m_currentConfig.getContextEngineId() != null) {
            ret.setContextEngineId(this.m_currentConfig.getContextEngineId());
        } else {
            ret.setContextEngineId(SnmpConfiguration.DEFAULT_CONTEXT_ENGINE_ID);
        }
        if (sourceConfig.getContextName() != null) {
            ret.setContextName(sourceConfig.getContextName());
        } else if (this.m_currentConfig.getContextName() != null) {
            ret.setContextName(this.m_currentConfig.getContextName());
        } else {
            ret.setContextName(SnmpConfiguration.DEFAULT_CONTEXT_NAME);
        }
        if (sourceConfig.getPrivacyPassphrase() != null) {
            ret.setPrivacyPassphrase(sourceConfig.getPrivacyPassphrase());
        } else if (this.m_currentConfig.getPrivacyPassphrase() != null) {
            ret.setPrivacyPassphrase(this.m_currentConfig.getPrivacyPassphrase());
        }
        if (sourceConfig.getPrivacyProtocol() != null) {
            ret.setPrivacyProtocol(sourceConfig.getPrivacyProtocol());
        } else if (this.m_currentConfig.getPrivacyProtocol() != null) {
            ret.setPrivacyProtocol(this.m_currentConfig.getPrivacyProtocol());
        } else {
            ret.setPrivacyProtocol("DES");
        }
        if (sourceConfig.getEnterpriseId() != null) {
            ret.setEnterpriseId(sourceConfig.getEnterpriseId());
        } else {
            ret.setEnterpriseId(this.m_currentConfig.getEnterpriseId());
        }
        if (sourceConfig.getVersion() != null) {
            ret.setVersion(sourceConfig.getVersion());
        } else if (this.m_currentConfig.getVersion() != null) {
            ret.setVersion(this.m_currentConfig.getVersion());
        } else {
            ret.setVersion(SnmpConfiguration.versionToString((int)1));
        }
        if (sourceConfig.getWriteCommunity() != null) {
            ret.setWriteCommunity(sourceConfig.getWriteCommunity());
        } else if (this.m_currentConfig.getWriteCommunity() != null) {
            ret.setWriteCommunity(this.m_currentConfig.getWriteCommunity());
        } else {
            ret.setWriteCommunity("private");
        }
        if (sourceConfig.getReadCommunity() != null) {
            ret.setReadCommunity(sourceConfig.getReadCommunity());
        } else if (this.m_currentConfig.getReadCommunity() != null) {
            ret.setReadCommunity(this.m_currentConfig.getReadCommunity());
        } else {
            ret.setReadCommunity("public");
        }
        if (sourceConfig.hasTimeout()) {
            ret.setTimeout(sourceConfig.getTimeout());
        } else if (this.m_currentConfig.hasTimeout()) {
            ret.setTimeout(this.m_currentConfig.getTimeout());
        } else {
            ret.setTimeout(3000);
        }
        if (sourceConfig.hasRetry()) {
            ret.setRetry(sourceConfig.getRetry());
        } else if (this.m_currentConfig.hasRetry()) {
            ret.setRetry(this.m_currentConfig.getRetry());
        } else {
            ret.setRetry(1);
        }
        if (sourceConfig.hasPort()) {
            ret.setPort(sourceConfig.getPort());
        } else if (this.m_currentConfig.hasPort()) {
            ret.setPort(this.m_currentConfig.getPort());
        } else {
            ret.setPort(161);
        }
        if (ret.getAuthPassphrase() == null) {
            ret.setAuthProtocol(null);
        }
        if (ret.getPrivacyPassphrase() == null) {
            ret.setPrivacyProtocol(null);
        }
        if (sourceConfig.hasSecurityLevel()) {
            ret.setSecurityLevel(sourceConfig.getSecurityLevel());
        } else if (this.m_currentConfig.hasSecurityLevel()) {
            ret.setSecurityLevel(this.m_currentConfig.getSecurityLevel());
        } else {
            int securityLevel = 1;
            securityLevel = this.isBlank(ret.getAuthPassphrase()) ? 1 : (this.isBlank(ret.getPrivacyPassphrase()) ? 2 : 3);
            ret.setSecurityLevel(securityLevel);
        }
        if (sourceConfig.hasTTL()) {
            ret.setTTL(sourceConfig.getTTL());
        } else if (this.m_currentConfig.hasTTL()) {
            ret.setTTL(this.m_currentConfig.getTTL());
        }
        this.m_generatedDefinition = ret;
    }

    public Definition getDefinition() {
        return this.m_generatedDefinition;
    }

    private boolean isBlank(String s) {
        return s == null || s.length() == 0 || s.trim().length() == 0;
    }
}

