/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.poller;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.core.network.InetAddressXmlAdapter;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.pagesequence.PageSequence;
import org.opennms.netmgt.config.poller.Monitor;
import org.opennms.netmgt.config.poller.NodeOutage;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Service;

@XmlRootElement(name="poller-configuration")
@ValidateUsing(value="poller-configuration.xsd")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlSeeAlso(value={PageSequence.class})
public class PollerConfiguration
implements Serializable {
    private static final long serialVersionUID = 3402898044699865749L;
    @XmlAttribute(name="threads")
    private Integer m_threads = 30;
    @XmlAttribute(name="nextOutageId")
    private String m_nextOutageId = "SELECT nextval('outageNxtId')";
    @XmlAttribute(name="serviceUnresponsiveEnabled")
    private String m_serviceUnresponsiveEnabled = "false";
    @XmlAttribute(name="pathOutageEnabled")
    private String m_pathOutageEnabled = "false";
    @XmlAttribute(name="defaultCriticalPathIp")
    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    private InetAddress m_defaultCriticalPathIp;
    @XmlAttribute(name="defaultCriticalPathService")
    private String m_defaultCriticalPathService;
    @XmlAttribute(name="defaultCriticalPathTimeout")
    private Integer m_defaultCriticalPathTimeout;
    @XmlAttribute(name="defaultCriticalPathRetries")
    private Integer m_defaultCriticalPathRetries;
    @XmlElement(name="node-outage")
    private NodeOutage m_nodeOutage;
    @XmlElement(name="package")
    private List<Package> m_packages = new ArrayList<Package>();
    @XmlElement(name="monitor")
    private List<Monitor> m_monitors = new ArrayList<Monitor>();

    public Integer getThreads() {
        return this.m_threads == null ? 0 : this.m_threads;
    }

    public void setThreads(Integer threads) {
        this.m_threads = threads;
    }

    public String getNextOutageId() {
        return this.m_nextOutageId == null ? "SELECT nextval('outageNxtId')" : this.m_nextOutageId;
    }

    public void setNextOutageId(String nextOutageId) {
        this.m_nextOutageId = nextOutageId;
    }

    public String getServiceUnresponsiveEnabled() {
        return this.m_serviceUnresponsiveEnabled;
    }

    public void setServiceUnresponsiveEnabled(String serviceUnresponsiveEnabled) {
        this.m_serviceUnresponsiveEnabled = serviceUnresponsiveEnabled;
    }

    public String getPathOutageEnabled() {
        return this.m_pathOutageEnabled == null ? "false" : this.m_pathOutageEnabled;
    }

    public void setPathOutageEnabled(String pathOutageEnabled) {
        this.m_pathOutageEnabled = pathOutageEnabled;
    }

    public NodeOutage getNodeOutage() {
        return this.m_nodeOutage;
    }

    public void setNodeOutage(NodeOutage nodeOutage) {
        this.m_nodeOutage = nodeOutage;
    }

    public List<Package> getPackages() {
        if (this.m_packages == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_packages);
    }

    public void setPackages(List<Package> packages) {
        this.m_packages = new ArrayList<Package>(packages);
    }

    public void addPackage(Package pack) throws IndexOutOfBoundsException {
        this.m_packages.add(pack);
    }

    public boolean removePackage(Package pack) {
        return this.m_packages.remove(pack);
    }

    public Package getPackage(String packageName) {
        for (Package pkg : this.m_packages) {
            if (!pkg.getName().equals(packageName)) continue;
            return pkg;
        }
        return null;
    }

    public List<Monitor> getMonitors() {
        if (this.m_monitors == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_monitors);
    }

    public void setMonitors(List<Monitor> monitors) {
        this.m_monitors = new ArrayList<Monitor>(monitors);
    }

    public void addMonitor(Monitor monitor) throws IndexOutOfBoundsException {
        this.m_monitors.add(monitor);
    }

    public void addMonitor(String service, String className) {
        this.addMonitor(new Monitor(service, className));
    }

    public boolean removeMonitor(Monitor monitor) {
        return this.m_monitors.remove(monitor);
    }

    public PollerConfiguration getPollerConfigurationForPackages(List<String> pollingPackageNames) {
        if (pollingPackageNames == null || pollingPackageNames.size() < 1) {
            return null;
        }
        HashSet<String> seenMonitors = new HashSet<String>();
        PollerConfiguration newConfig = new PollerConfiguration();
        newConfig.setThreads(this.getThreads());
        newConfig.setNextOutageId(this.getNextOutageId());
        newConfig.setServiceUnresponsiveEnabled(this.getServiceUnresponsiveEnabled());
        newConfig.setPathOutageEnabled(this.getPathOutageEnabled());
        newConfig.setNodeOutage(this.getNodeOutage());
        boolean foundPackage = false;
        for (String pollingPackageName : pollingPackageNames) {
            Package pkg = this.getPackage(pollingPackageName);
            if (pkg == null) continue;
            newConfig.addPackage(pkg);
            foundPackage = true;
            for (Service service : pkg.getServices()) {
                seenMonitors.add(service.getName());
            }
        }
        if (!foundPackage) {
            return null;
        }
        for (Monitor monitor : this.getMonitors()) {
            if (!seenMonitors.contains(monitor.getService())) continue;
            newConfig.addMonitor(monitor);
        }
        return newConfig;
    }

    public InetAddress getDefaultCriticalPathIp() {
        return this.m_defaultCriticalPathIp;
    }

    public void setDefaultCriticalPathIp(InetAddress ip) {
        this.m_defaultCriticalPathIp = ip;
    }

    public Integer getDefaultCriticalPathTimeout() {
        return this.m_defaultCriticalPathTimeout == null ? 1500 : this.m_defaultCriticalPathTimeout;
    }

    public void setDefaultCriticalPathTimeout(Integer timeout) {
        this.m_defaultCriticalPathTimeout = timeout;
    }

    public int getDefaultCriticalPathRetries() {
        return this.m_defaultCriticalPathRetries == null ? 0 : this.m_defaultCriticalPathRetries;
    }

    public void setDefaultCriticalPathRetries(Integer retries) {
        this.m_defaultCriticalPathRetries = retries;
    }

    public int hashCode() {
        return Objects.hash(this.m_threads, this.m_nextOutageId, this.m_serviceUnresponsiveEnabled, this.m_pathOutageEnabled, this.m_defaultCriticalPathIp, this.m_defaultCriticalPathService, this.m_defaultCriticalPathTimeout, this.m_defaultCriticalPathRetries, this.m_nodeOutage, this.m_packages, this.m_monitors);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PollerConfiguration that = (PollerConfiguration)o;
        return Objects.equals(this.m_threads, that.m_threads) && Objects.equals(this.m_nextOutageId, that.m_nextOutageId) && Objects.equals(this.m_serviceUnresponsiveEnabled, that.m_serviceUnresponsiveEnabled) && Objects.equals(this.m_pathOutageEnabled, that.m_pathOutageEnabled) && Objects.equals(this.m_defaultCriticalPathIp, that.m_defaultCriticalPathIp) && Objects.equals(this.m_defaultCriticalPathService, that.m_defaultCriticalPathService) && Objects.equals(this.m_defaultCriticalPathTimeout, that.m_defaultCriticalPathTimeout) && Objects.equals(this.m_defaultCriticalPathRetries, that.m_defaultCriticalPathRetries) && Objects.equals(this.m_nodeOutage, that.m_nodeOutage) && Objects.equals(this.m_packages, that.m_packages) && Objects.equals(this.m_monitors, that.m_monitors);
    }

    public String toString() {
        return "PollerConfiguration[threads=" + this.m_threads + ",nextOutageId=" + this.m_nextOutageId + ",serviceUnresponsiveEnabled=" + this.m_serviceUnresponsiveEnabled + ",pathOutageEnabled=" + this.m_pathOutageEnabled + ",pathOutageDefaultCriticalPathIp=" + this.m_defaultCriticalPathIp + ",pathOutageDefaultCriticalPathService=" + this.m_defaultCriticalPathService + ",pathOutageDefaultCriticalPathTimeout=" + this.m_defaultCriticalPathTimeout + ",pathOutageDefaultCriticalPathRetries=" + this.m_defaultCriticalPathRetries + ",nodeOutage=" + this.m_nodeOutage + ",packages=" + this.m_packages + ",monitors=" + this.m_monitors + "]";
    }
}

