/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.SocketUtils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import org.opennms.netmgt.telemetry.api.receiver.Listener;
import org.opennms.netmgt.telemetry.listeners.TcpParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpListener
implements Listener {
    private static final Logger LOG = LoggerFactory.getLogger(TcpListener.class);
    private final String name;
    private final TcpParser parser;
    private final Meter packetsReceived;
    private String host = null;
    private int port = 50000;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private ChannelFuture socketFuture;

    public TcpListener(String name, TcpParser parser, MetricRegistry metrics) {
        this.name = Objects.requireNonNull(name);
        this.parser = Objects.requireNonNull(parser);
        this.packetsReceived = metrics.meter(MetricRegistry.name((String)"listeners", (String[])new String[]{name, "packetsReceived"}));
    }

    public void start() throws InterruptedException {
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        this.parser.start((ScheduledExecutorService)this.bossGroup);
        InetSocketAddress address = this.host != null ? SocketUtils.socketAddress((String)this.host, (int)this.port) : new InetSocketAddress(this.port);
        this.socketFuture = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                final TcpParser.Handler session = TcpListener.this.parser.accept(ch.remoteAddress(), ch.localAddress());
                ch.pipeline().addFirst(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                        TcpListener.this.packetsReceived.mark();
                        super.channelRead(ctx, msg);
                    }
                }}).addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<ByteBuf>(){

                    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
                        session.parse(((ByteBuf)ReferenceCountUtil.retain((Object)msg)).nioBuffer()).handle((result, ex) -> {
                            ReferenceCountUtil.release((Object)msg);
                            if (ex != null) {
                                ctx.fireExceptionCaught(ex);
                            }
                            return result;
                        });
                    }
                }}).addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                        LOG.warn("Invalid packet: {}", (Object)cause.getMessage());
                        LOG.debug("", cause);
                        ctx.close();
                    }
                }});
            }
        }).bind((SocketAddress)address).sync();
    }

    public void stop() throws InterruptedException {
        LOG.info("Closing channel...");
        this.socketFuture.channel().close().sync();
        this.parser.stop();
        LOG.info("Closing boss group...");
        this.bossGroup.shutdownGracefully().sync();
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

