/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events.edir.eventdata;

import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.events.edir.EventResponseData;
import com.novell.ldap.events.edir.eventdata.DSETimeStamp;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class EntryEventData
implements EventResponseData {
    private final String perpetratorDN;
    private final String entry;
    private final String newdn;
    private final String classid;
    private final int verb;
    private final int flags;
    private final DSETimeStamp timeStamp;

    public EntryEventData(ASN1Object aSN1Object) throws IOException {
        byte[] byArray = ((ASN1OctetString)aSN1Object).byteValue();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        LBERDecoder lBERDecoder = new LBERDecoder();
        int[] nArray = new int[1];
        this.perpetratorDN = ((ASN1OctetString)lBERDecoder.decode(byteArrayInputStream, nArray)).stringValue();
        this.entry = ((ASN1OctetString)lBERDecoder.decode(byteArrayInputStream, nArray)).stringValue();
        this.classid = ((ASN1OctetString)lBERDecoder.decode(byteArrayInputStream, nArray)).stringValue();
        this.timeStamp = new DSETimeStamp((ASN1Sequence)lBERDecoder.decode(byteArrayInputStream, nArray));
        this.verb = ((ASN1Integer)lBERDecoder.decode(byteArrayInputStream, nArray)).intValue();
        this.flags = ((ASN1Integer)lBERDecoder.decode(byteArrayInputStream, nArray)).intValue();
        this.newdn = ((ASN1OctetString)lBERDecoder.decode(byteArrayInputStream, nArray)).stringValue();
    }

    public String getEntry() {
        return this.entry;
    }

    public String getPerpetratorDN() {
        return this.perpetratorDN;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getNewdn() {
        return this.newdn;
    }

    public String getClassid() {
        return this.classid;
    }

    public int getVerb() {
        return this.verb;
    }

    public DSETimeStamp getTimeStamp() {
        return this.timeStamp;
    }

    private void addObject(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append("(" + string + "=" + string2 + ")");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("EntryEventData[");
        this.addObject(stringBuffer, "Entry", this.getEntry());
        this.addObject(stringBuffer, "Prepetrator", this.getPerpetratorDN());
        this.addObject(stringBuffer, "ClassId", this.getClassid());
        stringBuffer.append("(Verb=" + this.getVerb() + ")");
        stringBuffer.append("(Flags=" + this.getFlags() + ")");
        stringBuffer.append("(NewDN=" + this.getNewdn() + ")");
        stringBuffer.append("(TimeStamp=" + this.getTimeStamp() + ")");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

