/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.controls;

import com.novell.ldap.LDAPControl;
import com.novell.ldap.asn1.ASN1Identifier;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1Tagged;
import com.novell.ldap.asn1.LBEREncoder;

public class LDAPVirtualListControl
extends LDAPControl {
    private static int BYOFFSET = 0;
    private static int GREATERTHANOREQUAL = 1;
    private static String requestOID = "2.16.840.1.113730.3.4.9";
    private static String responseOID = "2.16.840.1.113730.3.4.10";
    private ASN1Sequence m_vlvRequest;
    private int m_beforeCount;
    private int m_afterCount;
    private String m_jumpTo;
    private String m_context = null;
    private int m_startIndex = 0;
    private int m_contentCount = -1;

    public LDAPVirtualListControl(String string, int n, int n2) {
        this(string, n, n2, null);
    }

    public LDAPVirtualListControl(String string, int n, int n2, String string2) {
        super(requestOID, true, null);
        this.m_beforeCount = n;
        this.m_afterCount = n2;
        this.m_jumpTo = string;
        this.m_context = string2;
        this.BuildTypedVLVRequest();
        this.setValue(this.m_vlvRequest.getEncoding(new LBEREncoder()));
    }

    private void BuildTypedVLVRequest() {
        this.m_vlvRequest = new ASN1Sequence(4);
        this.m_vlvRequest.add(new ASN1Integer(this.m_beforeCount));
        this.m_vlvRequest.add(new ASN1Integer(this.m_afterCount));
        this.m_vlvRequest.add(new ASN1Tagged(new ASN1Identifier(2, false, GREATERTHANOREQUAL), new ASN1OctetString(this.m_jumpTo), false));
        if (this.m_context != null) {
            this.m_vlvRequest.add(new ASN1OctetString(this.m_context));
        }
    }

    public LDAPVirtualListControl(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, null);
    }

    public LDAPVirtualListControl(int n, int n2, int n3, int n4, String string) {
        super(requestOID, true, null);
        this.m_beforeCount = n2;
        this.m_afterCount = n3;
        this.m_startIndex = n;
        this.m_contentCount = n4;
        this.m_context = string;
        this.BuildIndexedVLVRequest();
        this.setValue(this.m_vlvRequest.getEncoding(new LBEREncoder()));
    }

    private void BuildIndexedVLVRequest() {
        this.m_vlvRequest = new ASN1Sequence(4);
        this.m_vlvRequest.add(new ASN1Integer(this.m_beforeCount));
        this.m_vlvRequest.add(new ASN1Integer(this.m_afterCount));
        ASN1Sequence aSN1Sequence = new ASN1Sequence(2);
        aSN1Sequence.add(new ASN1Integer(this.m_startIndex));
        aSN1Sequence.add(new ASN1Integer(this.m_contentCount));
        this.m_vlvRequest.add(new ASN1Tagged(new ASN1Identifier(2, true, BYOFFSET), aSN1Sequence, false));
        if (this.m_context != null) {
            this.m_vlvRequest.add(new ASN1OctetString(this.m_context));
        }
    }

    public int getAfterCount() {
        return this.m_afterCount;
    }

    public int getBeforeCount() {
        return this.m_beforeCount;
    }

    public int getListSize() {
        return this.m_contentCount;
    }

    public void setListSize(int n) {
        this.m_contentCount = n;
        this.BuildIndexedVLVRequest();
        this.setValue(this.m_vlvRequest.getEncoding(new LBEREncoder()));
    }

    public void setRange(int n, int n2, int n3) {
        this.m_beforeCount = n2;
        this.m_afterCount = n3;
        this.m_startIndex = n;
        this.BuildIndexedVLVRequest();
        this.setValue(this.m_vlvRequest.getEncoding(new LBEREncoder()));
    }

    public void setRange(String string, int n, int n2) {
        this.m_beforeCount = n;
        this.m_afterCount = n2;
        this.m_jumpTo = string;
        this.BuildTypedVLVRequest();
        this.setValue(this.m_vlvRequest.getEncoding(new LBEREncoder()));
    }

    public String getContext() {
        return this.m_context;
    }

    public void setContext(String string) {
        int n = 3;
        this.m_context = string;
        if (this.m_vlvRequest.size() == 4) {
            this.m_vlvRequest.set(n, new ASN1OctetString(this.m_context));
        } else if (this.m_vlvRequest.size() == 3) {
            this.m_vlvRequest.add(new ASN1OctetString(this.m_context));
        }
        this.setValue(this.m_vlvRequest.getEncoding(new LBEREncoder()));
    }

    static {
        try {
            LDAPControl.register(responseOID, Class.forName("com.novell.ldap.controls.LDAPVirtualListResponse"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

