/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.test;

import java.net.UnknownHostException;
import java.util.logging.Level;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JIComServer;
import org.jinterop.dcom.core.JIProgId;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIVariant;
import org.jinterop.dcom.impls.JIObjectFactory;
import org.jinterop.dcom.impls.automation.IJIDispatch;

public class MSExcel2_Test {
    private JIComServer comServer = null;
    private IJIDispatch dispatch = null;
    private IJIComObject unknown = null;
    private IJIDispatch dispatchOfWorkSheets = null;
    private IJIDispatch dispatchOfWorkBook = null;
    private IJIDispatch dispatchOfWorkSheet = null;
    private JISession session = null;
    static /* synthetic */ Class class$0;

    public MSExcel2_Test(String address, String[] args) throws JIException, UnknownHostException {
        this.session = JISession.createSession(args[1], args[2], args[3]);
        this.session.useSessionSecurity(true);
        this.comServer = new JIComServer(JIProgId.valueOf("Excel.Application"), address, this.session);
    }

    public void startExcel() throws JIException {
        this.unknown = this.comServer.createInstance();
        this.dispatch = (IJIDispatch)JIObjectFactory.narrowObject(this.unknown.queryInterface("00020400-0000-0000-c000-000000000046"));
    }

    public void showExcel() throws JIException {
        int dispId = this.dispatch.getIDsOfNames("Visible");
        JIVariant variant = new JIVariant(true);
        this.dispatch.put(dispId, variant);
    }

    public void createWorkSheet() throws JIException {
        int dispId = this.dispatch.getIDsOfNames("Workbooks");
        JIVariant outVal = this.dispatch.get(dispId);
        IJIDispatch dispatchOfWorkBooks = (IJIDispatch)JIObjectFactory.narrowObject(outVal.getObjectAsComObject());
        JIVariant[] outVal2 = dispatchOfWorkBooks.callMethodA("Add", new Object[]{JIVariant.OPTIONAL_PARAM()});
        this.dispatchOfWorkBook = (IJIDispatch)JIObjectFactory.narrowObject(outVal2[0].getObjectAsComObject());
        outVal = this.dispatchOfWorkBook.get("Worksheets");
        this.dispatchOfWorkSheets = (IJIDispatch)JIObjectFactory.narrowObject(outVal.getObjectAsComObject());
        outVal2 = this.dispatchOfWorkSheets.callMethodA("Add", new Object[]{JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
        this.dispatchOfWorkSheet = (IJIDispatch)JIObjectFactory.narrowObject(outVal2[0].getObjectAsComObject());
    }

    public void pasteArrayToWorkSheet(int nRow) throws JIException {
        int dispId = this.dispatchOfWorkSheet.getIDsOfNames("Range");
        JIVariant variant = new JIVariant(new JIString("A1:C" + nRow));
        Object[] objectArray = new Object[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jinterop.dcom.core.JIVariant");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[0] = clazz;
        Object[] out = objectArray;
        JIVariant[] outVal2 = this.dispatchOfWorkSheet.get(dispId, new Object[]{variant});
        IJIDispatch dispRange = (IJIDispatch)JIObjectFactory.narrowObject(outVal2[0].getObjectAsComObject());
        JIVariant[][] newValue = new JIVariant[nRow][3];
        int i = 0;
        while (i < newValue.length) {
            int j = 0;
            while (j < newValue[i].length) {
                newValue[i][j] = new JIVariant(10.0 * Math.random());
                ++j;
            }
            ++i;
        }
        dispRange.put("Value2", new JIVariant(new JIArray(newValue)));
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        JIVariant variant2 = dispRange.get("Value2");
        JIArray newValue2 = variant2.getObjectAsArray();
        newValue = (JIVariant[][])newValue2.getArrayInstance();
        int i2 = 0;
        while (i2 < newValue.length) {
            int j = 0;
            while (j < newValue[i2].length) {
                System.out.print(newValue[i2][j] + "\t");
                ++j;
            }
            System.out.println();
            ++i2;
        }
        dispRange.put("Value2", new JIVariant(newValue2));
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.dispatchOfWorkBook.callMethod("close", new Object[]{Boolean.FALSE, JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
        this.dispatch.callMethod("Quit");
        JISession.destroySession(this.session);
    }

    public static void main(String[] args) {
        try {
            JISystem.getLogger().setLevel(Level.FINEST);
            if (args.length < 4) {
                System.out.println("Please provide address domain username password");
                return;
            }
            int nRow = 600;
            if (args.length > 4) {
                try {
                    nRow = Integer.parseInt(args[4]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            MSExcel2_Test test = new MSExcel2_Test(args[0], args);
            test.startExcel();
            test.showExcel();
            test.createWorkSheet();
            test.pasteArrayToWorkSheet(nRow);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

