/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.fileutils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opennms.core.fileutils.FileUpdateCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUpdateWatcher {
    private static final Logger LOG = LoggerFactory.getLogger(FileUpdateWatcher.class);
    private final FileUpdateCallback callback;
    private final WatchService watcher;
    private final String fileName;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public FileUpdateWatcher(String fileName, FileUpdateCallback fileUpdateCb) throws IOException {
        File file = new File(fileName);
        if (!file.exists() || file.isDirectory()) {
            throw new IllegalArgumentException(String.format("file %s doesn't exist", fileName));
        }
        this.fileName = fileName;
        Path path = Paths.get(file.getParent(), new String[0]);
        this.callback = fileUpdateCb;
        this.watcher = path.getFileSystem().newWatchService();
        path.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
        Thread thread = new Thread(new FileWatcherThread());
        thread.setName(String.format("fileUpdateWatcher-%s", file.getName()));
        thread.start();
        LOG.info("started watcher thread for file : {}", (Object)file.getName());
    }

    public static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }

    public void destroy() {
        try {
            if (this.watcher != null) {
                this.watcher.close();
            }
        }
        catch (Exception e) {
            LOG.info("Exception while closing watcher", (Throwable)e);
        }
        this.closed.set(true);
    }

    private class FileWatcherThread
    implements Runnable {
        private FileWatcherThread() {
        }

        @Override
        public void run() {
            block2: while (!FileUpdateWatcher.this.closed.get()) {
                WatchKey key = null;
                try {
                    key = FileUpdateWatcher.this.watcher.take();
                }
                catch (Exception e) {
                    LOG.info("Watcher is either interruped or closed", (Throwable)e);
                    break;
                }
                for (WatchEvent<?> event : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = event.kind();
                    WatchEvent ev = FileUpdateWatcher.cast(event);
                    Path dir = (Path)key.watchable();
                    Path updatedFile = dir.resolve((Path)ev.context());
                    if ((kind == StandardWatchEventKinds.ENTRY_MODIFY || kind == StandardWatchEventKinds.ENTRY_CREATE) && updatedFile.toString().equals(FileUpdateWatcher.this.fileName)) {
                        LOG.info(" file {} got updated, send callback", (Object)updatedFile.getFileName());
                        FileUpdateWatcher.this.callback.reload();
                    }
                    if (key.reset()) continue;
                    continue block2;
                }
            }
        }
    }
}

