/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.kafka.client;

import org.opennms.core.ipc.sink.common.SinkStrategy;
import org.opennms.core.logging.Logging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.ImportResource;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@Conditional(value={Condition.class})
@ImportResource(value={"/META-INF/opennms/applicationContext-ipc-sink-kafka-client.xml"})
public class ConditionalKafkaSinkContext {
    private static final Logger LOG = LoggerFactory.getLogger(org.opennms.core.ipc.sink.kafka.server.ConditionalKafkaSinkContext.class);

    static class Condition
    implements ConfigurationCondition {
        Condition() {
        }

        public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
            return ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION;
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            boolean enabled = SinkStrategy.Strategy.KAFKA.equals((Object)SinkStrategy.getSinkStrategy());
            try (Logging.MDCCloseable mdc = Logging.withPrefixCloseable((String)"ipc");){
                LOG.debug("Enable Kafka Sink: {}", (Object)enabled);
            }
            return enabled;
        }
    }
}

