/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.opennmsDataSources;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.opennmsDataSources.Param;

@XmlRootElement(name="jdbc-data-source")
@XmlAccessorType(value=XmlAccessType.NONE)
public class JdbcDataSource
implements Serializable {
    private static final long serialVersionUID = -1120653287571635877L;
    @XmlAttribute(name="name", required=true)
    private String name;
    @XmlAttribute(name="database-name")
    private String databaseName;
    @XmlAttribute(name="schema-name")
    private String schemaName;
    @XmlAttribute(name="url", required=true)
    private String url;
    @XmlAttribute(name="class-name", required=true)
    private String className;
    @XmlAttribute(name="user-name")
    private String userName;
    @XmlAttribute(name="password")
    private String password;
    @XmlElement(name="param")
    private List<Param> paramList = new ArrayList<Param>();

    public void addParam(Param vParam) throws IndexOutOfBoundsException {
        this.paramList.add(vParam);
    }

    public void addParam(int index, Param vParam) throws IndexOutOfBoundsException {
        this.paramList.add(index, vParam);
    }

    public Enumeration<Param> enumerateParam() {
        return Collections.enumeration(this.paramList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JdbcDataSource) {
            JdbcDataSource temp = (JdbcDataSource)obj;
            boolean equals = Objects.equals(temp.name, this.name) && Objects.equals(temp.databaseName, this.databaseName) && Objects.equals(temp.schemaName, this.schemaName) && Objects.equals(temp.url, this.url) && Objects.equals(temp.className, this.className) && Objects.equals(temp.userName, this.userName) && Objects.equals(temp.password, this.password) && Objects.equals(temp.paramList, this.paramList);
            return equals;
        }
        return false;
    }

    public String getClassName() {
        return this.className;
    }

    public String getDatabaseName() {
        return this.databaseName != null ? this.databaseName : "opennms";
    }

    public String getName() {
        return this.name;
    }

    public Param getParam(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.paramList.size()) {
            throw new IndexOutOfBoundsException("getParam: Index value '" + index + "' not in range [0.." + (this.paramList.size() - 1) + "]");
        }
        return this.paramList.get(index);
    }

    public Param[] getParam() {
        Param[] array = new Param[]{};
        return this.paramList.toArray(array);
    }

    public List<Param> getParamCollection() {
        return this.paramList;
    }

    public int getParamCount() {
        return this.paramList.size();
    }

    public String getPassword() {
        return this.password;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserName() {
        return this.userName;
    }

    public int hashCode() {
        int hash = Objects.hash(this.name, this.databaseName, this.schemaName, this.url, this.className, this.userName, this.password, this.paramList);
        return hash;
    }

    public Iterator<Param> iterateParam() {
        return this.paramList.iterator();
    }

    public void removeAllParam() {
        this.paramList.clear();
    }

    public boolean removeParam(Param vParam) {
        boolean removed = this.paramList.remove(vParam);
        return removed;
    }

    public Param removeParamAt(int index) {
        Param obj = this.paramList.remove(index);
        return obj;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParam(int index, Param vParam) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.paramList.size()) {
            throw new IndexOutOfBoundsException("setParam: Index value '" + index + "' not in range [0.." + (this.paramList.size() - 1) + "]");
        }
        this.paramList.set(index, vParam);
    }

    public void setParam(Param[] vParamArray) {
        this.paramList.clear();
        for (int i = 0; i < vParamArray.length; ++i) {
            this.paramList.add(vParamArray[i]);
        }
    }

    public void setParam(List<Param> vParamList) {
        this.paramList.clear();
        this.paramList.addAll(vParamList);
    }

    public void setParamCollection(List<Param> paramList) {
        this.paramList = paramList;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }
}

