/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.Opaque;

public class IpV4 {
    public final Opaque<byte[]> ip_v4;

    public IpV4(ByteBuffer buffer) throws InvalidPacketException {
        this.ip_v4 = new Opaque<Object>(buffer, Optional.of(4), Opaque::parseBytes);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ip_v4", this.ip_v4).toString();
    }

    public void writeBson(BsonWriter bsonWriter) {
        try {
            bsonWriter.writeString(Inet4Address.getByAddress((byte[])this.ip_v4.value).getHostAddress());
        }
        catch (UnknownHostException e) {
            Throwables.propagate((Throwable)e);
        }
    }
}

