/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.utils.mate;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.core.rpc.utils.mate.ContextKey;
import org.opennms.core.rpc.utils.mate.Scope;

public class Interpolator {
    private static final String OUTER_REGEXP = "\\$\\{(.+?:.+?)\\}";
    private static final String INNER_REGEXP = "(?:([^\\|]+?:[^\\|]+)|([^\\|]+))";
    private static final Pattern OUTER_PATTERN = Pattern.compile("\\$\\{(.+?:.+?)\\}");
    private static final Pattern INNER_PATTERN = Pattern.compile("(?:([^\\|]+?:[^\\|]+)|([^\\|]+))");

    private Interpolator() {
    }

    public static Map<String, Object> interpolateObjects(Map<String, Object> attributes, Scope scope) {
        return Maps.transformValues(attributes, raw -> Interpolator.interpolate(raw, scope));
    }

    public static Map<String, String> interpolateStrings(Map<String, String> attributes, Scope scope) {
        return Maps.transformValues(attributes, raw -> Interpolator.interpolate(raw, scope));
    }

    public static Object interpolate(Object value, Scope scope) {
        if (value instanceof String) {
            return Interpolator.interpolate((String)value, scope);
        }
        return value;
    }

    public static String interpolate(String raw, Scope scope) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher outerMatcher = OUTER_PATTERN.matcher(raw);
        while (outerMatcher.find()) {
            Matcher innerMatcher = INNER_PATTERN.matcher(outerMatcher.group(1));
            String result = "";
            while (innerMatcher.find()) {
                if (innerMatcher.group(1) != null) {
                    String[] arr = innerMatcher.group(1).split(":", 2);
                    ContextKey contextKey = new ContextKey(arr[0], arr[1]);
                    Optional<String> replacement = scope.get(contextKey);
                    if (!replacement.isPresent()) continue;
                    result = Matcher.quoteReplacement(replacement.get());
                    break;
                }
                if (innerMatcher.group(2) == null) continue;
                result = Matcher.quoteReplacement(innerMatcher.group(2));
                break;
            }
            outerMatcher.appendReplacement(stringBuffer, result);
        }
        outerMatcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }
}

