/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser;

import java.nio.ByteBuffer;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.netmgt.telemetry.api.receiver.Dispatchable;
import org.opennms.netmgt.telemetry.api.receiver.TelemetryMessage;
import org.opennms.netmgt.telemetry.common.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.UdpParser;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.Protocol;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.UdpParserBase;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.RecordProvider;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.netflow9.proto.Header;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.netflow9.proto.Packet;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Session;

public class Netflow9UdpParser
extends UdpParserBase
implements UdpParser,
Dispatchable {
    public Netflow9UdpParser(String name, AsyncDispatcher<TelemetryMessage> dispatcher) {
        super(Protocol.NETFLOW9, name, dispatcher);
    }

    @Override
    protected RecordProvider parse(Session session, ByteBuffer buffer) throws Exception {
        Header header = new Header(BufferUtils.slice((ByteBuffer)buffer, (int)20));
        Packet packet = new Packet(session, header, buffer);
        return packet;
    }

    public boolean handles(ByteBuffer buffer) {
        return BufferUtils.uint16((ByteBuffer)buffer) == 9;
    }
}

