/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.aws.sqs.client;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.AmazonSQSException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.opennms.core.ipc.common.aws.sqs.AmazonSQSManager;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.ipc.sink.common.AbstractMessageDispatcherFactory;
import org.opennms.core.logging.Logging;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonSQSRemoteMessageDispatcherFactory
extends AbstractMessageDispatcherFactory<String> {
    private static final Logger LOG = LoggerFactory.getLogger(AmazonSQSRemoteMessageDispatcherFactory.class);
    private AmazonSQS sqs;
    private AmazonSQSManager awsSqsManager;
    private BundleContext bundleContext;

    public <S extends Message, T extends Message> void dispatch(SinkModule<S, T> module, String topic, T message) {
        try (Logging.MDCCloseable mdc = Logging.withPrefixCloseable((String)"ipc");){
            LOG.trace("dispatch({}): sending message {}", (Object)topic, message);
            try {
                String queueUrl = this.awsSqsManager.getSinkQueueUrlAndCreateIfNecessary(module.getId());
                String messageId = this.awsSqsManager.sendMessage(queueUrl, new String(module.marshal(message), StandardCharsets.UTF_8));
                LOG.debug("SQS Message with ID {} has been successfully sent to {}", (Object)messageId, (Object)queueUrl);
            }
            catch (InterruptedException ex) {
                LOG.warn("Interrupted while trying to send message. Aborting.", (Throwable)ex);
            }
            catch (RuntimeException ex) {
                LOG.error("Unexpected AWS SDK exception while sending a message. Aborting.", (Throwable)ex);
            }
        }
    }

    public void init() throws IOException {
        try (Logging.MDCCloseable mdc = Logging.withPrefixCloseable((String)"ipc");){
            try {
                this.sqs = this.awsSqsManager.getSQSClient();
            }
            catch (AmazonSQSException e) {
                LOG.error("Can't create an AmazonSQS Object", (Throwable)e);
            }
            this.onInit();
        }
    }

    public void destroy() {
        this.onDestroy();
        this.sqs.shutdown();
    }

    public String getMetricDomain() {
        return "org.opennms.core.ipc.sink.producer";
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setAwsSqsManager(AmazonSQSManager awsSqsManager) {
        this.awsSqsManager = awsSqsManager;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

