/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http;

import java.util.Vector;

public class HttpHeaderParser {
    String iRaw;
    Vector iNameValuePair;

    public HttpHeaderParser(String s) {
        this.iRaw = s;
        this.iNameValuePair = new Vector();
        if (this.iRaw != null) {
            this.iRaw = this.iRaw.trim();
            char[] charArray = this.iRaw.toCharArray();
            int startPosValue = 0;
            int currentPos = 0;
            boolean isName = true;
            boolean withinQuote = false;
            int len = charArray.length;
            String[] nvp = new String[2];
            do {
                char c;
                if ((c = charArray[currentPos]) == '=') {
                    nvp[0] = new String(charArray, startPosValue, currentPos - startPosValue).toLowerCase();
                    isName = false;
                    startPosValue = ++currentPos;
                    continue;
                }
                if (c == '\"') {
                    if (withinQuote) {
                        nvp[1] = new String(charArray, startPosValue, currentPos - startPosValue);
                        this.iNameValuePair.add(nvp);
                        nvp = new String[2];
                        withinQuote = false;
                        while (++currentPos < len && (charArray[currentPos] == ' ' || charArray[currentPos] == ',' || charArray[currentPos] == ';')) {
                        }
                        isName = true;
                        startPosValue = currentPos;
                        continue;
                    }
                    withinQuote = true;
                    startPosValue = ++currentPos;
                    continue;
                }
                if (c == ' ' || c == ',' || c == ';') {
                    if (withinQuote) {
                        ++currentPos;
                        continue;
                    }
                    if (isName) {
                        nvp[0] = new String(charArray, startPosValue, currentPos - startPosValue).toLowerCase();
                        this.iNameValuePair.add(nvp);
                        nvp = new String[2];
                    } else {
                        nvp[1] = new String(charArray, startPosValue, currentPos - startPosValue);
                        this.iNameValuePair.add(nvp);
                        nvp = new String[2];
                    }
                    while (++currentPos < len && (charArray[currentPos] == ' ' || charArray[currentPos] == ',' || charArray[currentPos] == ';')) {
                    }
                    isName = true;
                    startPosValue = currentPos;
                    continue;
                }
                ++currentPos;
            } while (currentPos < len);
            if (--currentPos > startPosValue) {
                if (!isName) {
                    if (charArray[currentPos] == '\"') {
                        nvp[1] = new String(charArray, startPosValue, currentPos - startPosValue);
                        this.iNameValuePair.add(nvp);
                        nvp = new String[2];
                    } else {
                        nvp[1] = new String(charArray, startPosValue, currentPos - startPosValue + 1);
                        this.iNameValuePair.add(nvp);
                        nvp = new String[2];
                    }
                } else {
                    nvp[0] = new String(charArray, startPosValue, currentPos - startPosValue + 1).toLowerCase();
                }
                this.iNameValuePair.add(nvp);
            } else if (currentPos == startPosValue) {
                if (!isName) {
                    if (charArray[currentPos] == '\"') {
                        nvp[1] = String.valueOf(charArray[currentPos - 1]);
                        this.iNameValuePair.add(nvp);
                        nvp = new String[2];
                    } else {
                        nvp[1] = String.valueOf(charArray[currentPos]);
                        this.iNameValuePair.add(nvp);
                        nvp = new String[2];
                    }
                } else {
                    nvp[0] = String.valueOf(charArray[currentPos]).toLowerCase();
                }
                this.iNameValuePair.add(nvp);
            }
        }
    }

    public String findKey(int i) {
        if (i < 0 || i > this.iNameValuePair.size()) {
            return null;
        }
        return ((String[])this.iNameValuePair.elementAt(i))[0];
    }

    public String findValue(int i) {
        if (i < 0 || i > this.iNameValuePair.size()) {
            return null;
        }
        return ((String[])this.iNameValuePair.elementAt(i))[1];
    }

    public String findValue(String s) {
        return this.findValue(s, null);
    }

    public String findValue(String name, String defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        name.toLowerCase();
        for (int i = 0; i < this.iNameValuePair.size(); ++i) {
            if (((String[])this.iNameValuePair.elementAt(i))[0] == null) {
                return defaultValue;
            }
            if (!name.equals(((String[])this.iNameValuePair.elementAt(i))[0])) continue;
            return ((String[])this.iNameValuePair.elementAt(i))[1];
        }
        return defaultValue;
    }

    public int findInt(String name, int defaultValue) {
        try {
            return Integer.parseInt(this.findValue(name, String.valueOf(defaultValue)));
        }
        catch (Throwable throwable) {
            return defaultValue;
        }
    }

    public String toString() {
        return "raw:" + this.iRaw;
    }
}

