/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.camel;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointInject;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.direct.DirectConsumerNotAvailableException;
import org.apache.camel.spi.Synchronization;
import org.opennms.core.logging.Logging;
import org.opennms.core.rpc.api.RemoteExecutionException;
import org.opennms.core.rpc.api.RequestRejectedException;
import org.opennms.core.rpc.api.RequestTimedOutException;
import org.opennms.core.rpc.api.RpcClient;
import org.opennms.core.rpc.api.RpcClientFactory;
import org.opennms.core.rpc.api.RpcModule;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.core.rpc.api.RpcResponse;
import org.opennms.core.rpc.camel.CamelRpcRequest;
import org.opennms.core.tracing.api.TracerRegistry;
import org.opennms.core.tracing.util.TracingInfoCarrier;
import org.opennms.core.utils.SystemInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CamelRpcClientFactory
implements RpcClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CamelRpcClientFactory.class);
    private String location;
    @EndpointInject(uri="direct:executeRpc", context="rpcClient")
    private ProducerTemplate template;
    @EndpointInject(uri="direct:executeRpc", context="rpcClient")
    private Endpoint endpoint;
    @Autowired
    private TracerRegistry tracerRegistry;
    private Tracer tracer;

    public <S extends RpcRequest, T extends RpcResponse> RpcClient<S, T> getClient(final RpcModule<S, T> module) {
        return new RpcClient<S, T>(){

            public CompletableFuture<T> execute(S request) {
                if (request.getLocation() == null || request.getLocation().equals(CamelRpcClientFactory.this.location)) {
                    return module.execute(request);
                }
                final Map clientContextMap = Logging.getCopyOfContextMap();
                final Span span = CamelRpcClientFactory.this.tracer.buildSpan(module.getId()).start();
                span.setTag("location", request.getLocation());
                if (request.getSystemId() != null) {
                    span.setTag("systemId", request.getSystemId());
                }
                request.getTracingInfo().forEach((arg_0, arg_1) -> ((Span)span).setTag(arg_0, arg_1));
                TracingInfoCarrier tracingInfoCarrier = new TracingInfoCarrier();
                CamelRpcClientFactory.this.tracer.inject(span.context(), Format.Builtin.TEXT_MAP, (Object)tracingInfoCarrier);
                request.getTracingInfo().forEach((arg_0, arg_1) -> ((TracingInfoCarrier)tracingInfoCarrier).put(arg_0, arg_1));
                final CompletableFuture future = new CompletableFuture();
                try {
                    CamelRpcClientFactory.this.template.asyncCallbackSendBody(CamelRpcClientFactory.this.endpoint, new CamelRpcRequest(module, request, tracingInfoCarrier.getTracingInfoMap()), new Synchronization(){

                        public void onComplete(Exchange exchange) {
                            try (Logging.MDCCloseable mdc = Logging.withContextMapCloseable((Map)clientContextMap);){
                                RpcResponse response = module.unmarshalResponse((String)exchange.getOut().getBody(String.class));
                                if (response.getErrorMessage() != null) {
                                    future.completeExceptionally((Throwable)new RemoteExecutionException(response.getErrorMessage()));
                                    span.setTag("failed", "true");
                                    span.log(response.getErrorMessage());
                                } else {
                                    future.complete(response);
                                }
                            }
                            catch (Throwable ex) {
                                LOG.error("Unmarshalling a response in RPC module {} failed.", (Object)module, (Object)ex);
                                future.completeExceptionally(ex);
                                span.setTag("failed", "true");
                                span.log(ex.getMessage());
                            }
                            span.finish();
                            Logging.putPrefix((String)"ipc");
                        }

                        public void onFailure(Exchange exchange) {
                            try (Logging.MDCCloseable mdc = Logging.withContextMapCloseable((Map)clientContextMap);){
                                ExchangeTimedOutException timeoutException = (ExchangeTimedOutException)exchange.getException(ExchangeTimedOutException.class);
                                DirectConsumerNotAvailableException directConsumerNotAvailableException = (DirectConsumerNotAvailableException)exchange.getException(DirectConsumerNotAvailableException.class);
                                if (timeoutException != null) {
                                    future.completeExceptionally((Throwable)new RequestTimedOutException((Throwable)exchange.getException()));
                                    span.setTag("timeout", "true");
                                } else if (directConsumerNotAvailableException != null) {
                                    future.completeExceptionally((Throwable)new RequestRejectedException((Throwable)exchange.getException()));
                                } else {
                                    future.completeExceptionally(exchange.getException());
                                }
                            }
                            span.setTag("failed", "true");
                            span.log(exchange.getException().getMessage());
                            span.finish();
                            Logging.putPrefix((String)"ipc");
                        }
                    });
                }
                catch (IllegalStateException e) {
                    try (Logging.MDCCloseable mdc = Logging.withContextMapCloseable((Map)clientContextMap);){
                        future.completeExceptionally((Throwable)new RequestRejectedException((Throwable)e));
                        span.setTag("failed", "true");
                        span.log(e.getMessage());
                        span.finish();
                    }
                    Logging.putPrefix((String)"ipc");
                }
                return future;
            }
        };
    }

    public TracerRegistry getTracerRegistry() {
        return this.tracerRegistry;
    }

    public void setTracerRegistry(TracerRegistry tracerRegistry) {
        this.tracerRegistry = tracerRegistry;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void start() {
        this.tracerRegistry.init(SystemInfoUtils.getInstanceId());
        this.tracer = this.tracerRegistry.getTracer();
    }

    public void stop() {
    }
}

