/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.opennms.netmgt.provision.annotations.Require;
import org.springframework.beans.BeanWrapperImpl;

public class PluginWrapper {
    private Map<String, Set<String>> m_required = new TreeMap<String, Set<String>>();
    private Map<String, Set<String>> m_optional = new TreeMap<String, Set<String>>();
    private final String m_className;

    public PluginWrapper(String className) throws ClassNotFoundException {
        this(Class.forName(className));
    }

    public PluginWrapper(Class<?> clazz) throws ClassNotFoundException {
        this.m_className = clazz.getName();
        BeanWrapperImpl wrapper = new BeanWrapperImpl(Class.forName(this.m_className));
        for (PropertyDescriptor pd : wrapper.getPropertyDescriptors()) {
            Method m;
            if (pd.getName().equals("class") || (m = pd.getReadMethod()) == null) continue;
            if (m.isAnnotationPresent(Require.class)) {
                TreeSet<String> values = new TreeSet<String>();
                Require a = m.getAnnotation(Require.class);
                for (String key : a.value()) {
                    values.add(key);
                }
                this.m_required.put(pd.getName(), values);
                continue;
            }
            this.m_optional.put(pd.getName(), new HashSet());
        }
    }

    public String getClassName() {
        return this.m_className;
    }

    public Map<String, Boolean> getRequired() {
        HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
        for (String key : this.m_required.keySet()) {
            ret.put(key, true);
        }
        for (String key : this.m_optional.keySet()) {
            ret.put(key, false);
        }
        return ret;
    }

    public Set<String> getRequiredKeys() {
        return this.m_required.keySet();
    }

    public Set<String> getOptionalKeys() {
        return this.m_optional.keySet();
    }

    public Map<String, Set<String>> getRequiredItems() {
        return this.m_required;
    }

    public Map<String, Set<String>> getOptionalItems() {
        return this.m_optional;
    }
}

