/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.common.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.FlowData;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.IpV4;

public class SampledIpv4
implements FlowData {
    public final long length;
    public final long protocol;
    public final IpV4 src_ip;
    public final IpV4 dst_ip;
    public final long src_port;
    public final long dst_port;
    public final long tcp_flags;
    public final long tos;

    public SampledIpv4(ByteBuffer buffer) throws InvalidPacketException {
        this.length = BufferUtils.uint32((ByteBuffer)buffer);
        this.protocol = BufferUtils.uint32((ByteBuffer)buffer);
        this.src_ip = new IpV4(buffer);
        this.dst_ip = new IpV4(buffer);
        this.src_port = BufferUtils.uint32((ByteBuffer)buffer);
        this.dst_port = BufferUtils.uint32((ByteBuffer)buffer);
        this.tcp_flags = BufferUtils.uint32((ByteBuffer)buffer);
        this.tos = BufferUtils.uint32((ByteBuffer)buffer);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("length", this.length).add("protocol", this.protocol).add("src_ip", (Object)this.src_ip).add("dst_ip", (Object)this.dst_ip).add("src_port", this.src_port).add("dst_port", this.dst_port).add("tcp_flags", this.tcp_flags).add("tos", this.tos).toString();
    }

    @Override
    public void writeBson(BsonWriter bsonWriter) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeInt32("length", (int)this.length);
        bsonWriter.writeInt32("protocol", (int)this.protocol);
        bsonWriter.writeName("src_ip");
        this.src_ip.writeBson(bsonWriter);
        bsonWriter.writeName("dst_ip");
        this.dst_ip.writeBson(bsonWriter);
        bsonWriter.writeInt32("src_port", (int)this.src_port);
        bsonWriter.writeInt32("dst_port", (int)this.dst_port);
        bsonWriter.writeInt32("tcp_flags", (int)this.tcp_flags);
        bsonWriter.writeInt32("tos", (int)this.tos);
        bsonWriter.writeEndDocument();
    }
}

