/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedLong;
import java.nio.ByteBuffer;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.common.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.AsciiString;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.DurationUs;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.FlowData;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.Ieee80211Version;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.Mac;

public class Extended80211Rx
implements FlowData {
    public final AsciiString ssid;
    public final Mac bssid;
    public final Ieee80211Version version;
    public final long channel;
    public final UnsignedLong speed;
    public final long rsni;
    public final long rcpi;
    public final DurationUs packet_duration;

    public Extended80211Rx(ByteBuffer buffer) throws InvalidPacketException {
        this.ssid = new AsciiString(buffer);
        this.bssid = new Mac(buffer);
        this.version = Ieee80211Version.from(buffer);
        this.channel = BufferUtils.uint32((ByteBuffer)buffer);
        this.speed = BufferUtils.uint64((ByteBuffer)buffer);
        this.rsni = BufferUtils.uint32((ByteBuffer)buffer);
        this.rcpi = BufferUtils.uint32((ByteBuffer)buffer);
        this.packet_duration = new DurationUs(buffer);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ssid", (Object)this.ssid).add("bssid", (Object)this.bssid).add("version", (Object)this.version).add("channel", this.channel).add("speed", (Object)this.speed).add("rsni", this.rsni).add("rcpi", this.rcpi).add("packet_duration", (Object)this.packet_duration).toString();
    }

    @Override
    public void writeBson(BsonWriter bsonWriter) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeString("ssid", this.ssid.value);
        bsonWriter.writeName("bssid");
        this.bssid.writeBson(bsonWriter);
        bsonWriter.writeName("version");
        this.version.writeBson(bsonWriter);
        bsonWriter.writeInt64("channel", this.channel);
        bsonWriter.writeInt64("speed", this.speed.longValue());
        bsonWriter.writeInt64("rsni", this.rsni);
        bsonWriter.writeInt64("rcpi", this.rcpi);
        bsonWriter.writeName("packet_duration");
        this.packet_duration.writeBson(bsonWriter);
        bsonWriter.writeEndDocument();
    }
}

